/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.reduction;

import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.Pair;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

class StackSizeSimulator {
    private List<Pair<Integer, Integer>> stackSizes;

    StackSizeSimulator() {
    }

    void buildStackSizes(List<Instruction> instructions) {
        this.stackSizes = new ArrayList<Pair<Integer, Integer>>();
        int stackSize = 0;
        for (Instruction instruction : instructions) {
            int previousStackSize = stackSize;
            stackSize += instruction.getStackSizeDifference();
            if (StackSizeSimulator.isStackCleared(instruction)) {
                stackSize = 0;
            }
            if (stackSize < 0) {
                throw new IllegalStateException("Runtime stack under-flow occurred.");
            }
            this.stackSizes.add(Pair.of(previousStackSize, stackSize));
        }
    }

    private static boolean isStackCleared(Instruction instruction) {
        return instruction.getType() == Instruction.Type.RETURN || instruction.getType() == Instruction.Type.THROW;
    }

    List<Integer> simulateStatementBackwards(int backtrackPosition) {
        int currentPosition = backtrackPosition;
        while (this.stackSizes.get(currentPosition).getLeft() > 0) {
            --currentPosition;
        }
        return Stream.iterate(backtrackPosition, c -> {
            c = c - 1;
            return c;
        }).limit(backtrackPosition - currentPosition + 1).collect(LinkedList::new, Collection::add, Collection::addAll);
    }

    Set<Integer> findLoadStoreBacktrackPositions(Set<Integer> loadStorePositions) {
        return loadStorePositions.stream().map(this::findBacktrackPosition).collect(Collectors.toSet());
    }

    private int findBacktrackPosition(int position) {
        int currentPosition = position;
        while (this.stackSizes.get(currentPosition).getRight() > 0) {
            ++currentPosition;
        }
        return currentPosition;
    }
}

