/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.List;
import java.util.function.BiFunction;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

enum KnownJsonResultMethod implements IdentifiableMethod
{
    JSON_ARRAY_BUILDER_CREATE(MethodIdentifier.ofStatic(KnownNames.JSON, "createArrayBuilder", KnownNames.JSON_ARRAY_BUILDER, new String[0]), (object, arguments) -> new Element(KnownNames.JSON_ARRAY, new com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray())),
    JSON_ARRAY_BUILDER_ADD_BIG_DECIMAL(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, "java.math.BigDecimal"), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_BIG_INTEGER(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, "java.math.BigInteger"), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_STRING(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, KnownNames.STRING), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_INT(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, "int"), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_LONG(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, "long"), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_DOUBLE(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, "double"), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_BOOLEAN(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, "boolean"), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, KnownNames.BOOLEAN)),
    JSON_ARRAY_BUILDER_ADD_JSON(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, KnownNames.JSON_VALUE), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_JSON_OBJECT(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, KnownNames.JSON_OBJECT_BUILDER), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, KnownNames.JSON_OBJECT)),
    JSON_ARRAY_BUILDER_ADD_JSON_ARRAY(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "add", KnownNames.JSON_ARRAY_BUILDER, KnownNames.JSON_ARRAY_BUILDER), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, KnownNames.JSON_ARRAY)),
    JSON_ARRAY_BUILDER_ADD_NULL(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "addNull", KnownNames.JSON_ARRAY_BUILDER, new String[0]), (object, arguments) -> {
        object.getPossibleValues().stream().filter(o -> o instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray).map(o -> (com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray)o).forEach(a -> a.getElements().add(new Element(KnownNames.OBJECT, null)));
        return object;
    }),
    JSON_ARRAY_BUILDER_BUILD(MethodIdentifier.ofNonStatic(KnownNames.JSON_ARRAY_BUILDER, "build", KnownNames.JSON_ARRAY, new String[0]), (object, arguments) -> {
        Element json = new Element(KnownNames.JSON_ARRAY, new Object[0]);
        json.merge((Element)object);
        return json;
    }),
    JSON_OBJECT_BUILDER_CREATE(MethodIdentifier.ofStatic(KnownNames.JSON, "createObjectBuilder", KnownNames.JSON_OBJECT_BUILDER, new String[0]), (object, arguments) -> new Element(KnownNames.JSON_OBJECT, new com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject())),
    JSON_OBJECT_BUILDER_ADD_BIG_DECIMAL(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, "java.math.BigDecimal"), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_BIG_INTEGER(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, "java.math.BigInteger"), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_STRING(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, KnownNames.STRING), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_INT(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, "int"), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_LONG(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, "long"), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_DOUBLE(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, "double"), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_BOOLEAN(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, "boolean"), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, KnownNames.BOOLEAN)),
    JSON_OBJECT_BUILDER_ADD_JSON(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, KnownNames.JSON_VALUE), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_JSON_OBJECT(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, KnownNames.JSON_OBJECT_BUILDER), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, KnownNames.JSON_OBJECT)),
    JSON_OBJECT_BUILDER_ADD_JSON_ARRAY(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "add", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING, KnownNames.JSON_ARRAY_BUILDER), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, KnownNames.JSON_ARRAY)),
    JSON_OBJECT_BUILDER_ADD_NULL(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "addNull", KnownNames.JSON_OBJECT_BUILDER, KnownNames.STRING), (object, arguments) -> {
        object.getPossibleValues().stream().filter(o -> o instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject).map(o -> (com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject)o).forEach(o -> ((Element)arguments.get(0)).getPossibleValues().stream().map(s -> (String)s).forEach(s -> o.getStructure().merge((String)s, new Element(KnownNames.OBJECT, null), Element::merge)));
        return object;
    }),
    JSON_OBJECT_BUILDER_BUILD(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT_BUILDER, "build", KnownNames.JSON_OBJECT, new String[0]), (object, arguments) -> {
        Element json = new Element(KnownNames.JSON_OBJECT, new Object[0]);
        json.merge((Element)object);
        return json;
    }),
    JSON_OBJECT_GET_BOOLEAN(MethodIdentifier.ofNonStatic(KnownNames.JSON_OBJECT, "getBoolean", "boolean", KnownNames.STRING), (object, arguments) -> object.getPossibleValues().stream().filter(o -> o instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject).map(o -> (com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject)o).map(o -> ((Element)arguments.get(0)).getPossibleValues().stream().map(s -> (String)s).map(s -> o.getStructure().get(s)).reduce(new Element(KnownNames.BOOLEAN, new Object[0]), Element::merge)).reduce(new Element(KnownNames.BOOLEAN, new Object[0]), Element::merge));

    private final MethodIdentifier identifier;
    private final BiFunction<Element, List<Element>, Element> function;

    private KnownJsonResultMethod(MethodIdentifier identifier, BiFunction<Element, List<Element>, Element> function) {
        this.identifier = identifier;
        this.function = function;
    }

    @Override
    public Element invoke(Element object, List<Element> arguments) {
        if (arguments.size() != this.identifier.getParameterTypes().length) {
            throw new IllegalArgumentException("Method arguments do not match expected signature!");
        }
        return this.function.apply(object, arguments);
    }

    @Override
    public boolean matches(MethodIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    private static Element addToArray(Element object, List<Element> arguments) {
        return KnownJsonResultMethod.addToArray(object, arguments.get(0));
    }

    private static Element addToArray(Element object, List<Element> arguments, String typeOverride) {
        Element element = new Element(typeOverride, new Object[0]);
        element.merge(arguments.get(0));
        return KnownJsonResultMethod.addToArray(object, element);
    }

    private static Element addToArray(Element object, Element argument) {
        object.getPossibleValues().stream().filter(o -> o instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray).map(o -> (com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray)o).forEach(a -> a.getElements().add(argument));
        return object;
    }

    private static Element mergeJsonStructure(Element object, List<Element> arguments) {
        Element element = new Element(arguments.get(1).getType(), new Object[0]);
        element.merge(arguments.get(1));
        return KnownJsonResultMethod.mergeJsonStructure(object, arguments.get(0), element);
    }

    private static Element mergeJsonStructure(Element object, List<Element> arguments, String typeOverride) {
        Element element = new Element(typeOverride, new Object[0]);
        element.merge(arguments.get(1));
        return KnownJsonResultMethod.mergeJsonStructure(object, arguments.get(0), element);
    }

    private static Element mergeJsonStructure(Element object, Element key, Element argument) {
        object.getPossibleValues().stream().filter(o -> o instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject).map(o -> (com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject)o).forEach(o -> key.getPossibleValues().stream().map(s -> (String)s).forEach(s -> o.getStructure().merge((String)s, argument, Element::merge)));
        return object;
    }

    static class KnownNames {
        static final String JSON = Json.class.getName();
        static final String JSON_OBJECT_BUILDER = JsonObjectBuilder.class.getName();
        static final String JSON_ARRAY_BUILDER = JsonArrayBuilder.class.getName();
        static final String JSON_VALUE = JsonValue.class.getName();
        static final String JSON_OBJECT = JsonObject.class.getName();
        static final String JSON_ARRAY = JsonArray.class.getName();
        static final String OBJECT = Object.class.getName();
        static final String STRING = String.class.getName();
        static final String BOOLEAN = Boolean.class.getName();

        KnownNames() {
        }
    }
}

