/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.MethodHandle;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.lang.annotation.Annotation;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

enum KnownResponseResultMethod implements IdentifiableMethod
{
    RESPONSE_BUILDER_BUILD(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "build", KnownNames.RESPONSE, new String[0]), (object, arguments) -> object),
    RESPONSE_BUILDER_CACHE_CONTROL(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "cacheControl", KnownNames.RESPONSE_BUILDER, CacheControl.class.getName()), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Cache-Control")),
    RESPONSE_BUILDER_CONTENT_LOCATION(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "contentLocation", KnownNames.RESPONSE_BUILDER, KnownNames.URI), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Location")),
    RESPONSE_BUILDER_COOKIE(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "cookie", KnownNames.RESPONSE_BUILDER, NewCookie.class.getName() + "[]"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Set-Cookie")),
    RESPONSE_BUILDER_ENCODING(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "encoding", KnownNames.RESPONSE_BUILDER, KnownNames.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Encoding")),
    RESPONSE_BUILDER_ENTITY(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "entity", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT), (object, arguments) -> KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0))),
    RESPONSE_BUILDER_ENTITY_ANNOTATION(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "entity", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT, Annotation.class.getName() + "[]"), (object, arguments) -> KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0))),
    RESPONSE_BUILDER_EXPIRES(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "expires", KnownNames.RESPONSE_BUILDER, KnownNames.DATE), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Expires")),
    RESPONSE_BUILDER_HEADER(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "header", KnownNames.RESPONSE_BUILDER, KnownNames.STRING, KnownNames.OBJECT), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(header -> (String)header).forEach(h -> KnownResponseResultMethod.addHeader(object, h));
        return object;
    }),
    RESPONSE_BUILDER_LANGUAGE_LOCALE(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "language", KnownNames.RESPONSE_BUILDER, Locale.class.getName()), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Language")),
    RESPONSE_BUILDER_LANGUAGE_STRING(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "language", KnownNames.RESPONSE_BUILDER, KnownNames.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Language")),
    RESPONSE_BUILDER_LAST_MODIFIED(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "lastModified", KnownNames.RESPONSE_BUILDER, KnownNames.DATE), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Last-Modified")),
    RESPONSE_BUILDER_LINK_URI(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "link", KnownNames.RESPONSE_BUILDER, KnownNames.URI, KnownNames.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LINK_STRING(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "link", KnownNames.RESPONSE_BUILDER, KnownNames.STRING, KnownNames.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LINKS(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "links", KnownNames.RESPONSE_BUILDER, Link.class.getName() + "[]"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LOCATION(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "location", KnownNames.RESPONSE_BUILDER, KnownNames.URI), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Location")),
    RESPONSE_BUILDER_STATUS_ENUM(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "status", KnownNames.RESPONSE_BUILDER, KnownNames.RESPONSE_STATUS), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_BUILDER_STATUS_INT(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "status", KnownNames.RESPONSE_BUILDER, "int"), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_BUILDER_TAG_ENTITY(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "tag", KnownNames.RESPONSE_BUILDER, EntityTag.class.getName()), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "ETag")),
    RESPONSE_BUILDER_TAG_STRING(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "tag", KnownNames.RESPONSE_BUILDER, KnownNames.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "ETag")),
    RESPONSE_BUILDER_TYPE(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "type", KnownNames.RESPONSE_BUILDER, MediaType.class.getName()), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(m -> (MediaType)m).map(m -> m.getType() + '/' + m.getSubtype()).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return object;
    }),
    RESPONSE_BUILDER_TYPE_STRING(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "type", KnownNames.RESPONSE_BUILDER, KnownNames.STRING), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(t -> (String)t).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return object;
    }),
    RESPONSE_BUILDER_VARIANT(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "variant", KnownNames.RESPONSE_BUILDER, KnownNames.VARIANT), (object, arguments) -> {
        KnownResponseResultMethod.addHeader(object, "Content-Language");
        KnownResponseResultMethod.addHeader(object, "Content-Encoding");
        return object;
    }),
    RESPONSE_BUILDER_VARIANTS_LIST(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "variants", KnownNames.RESPONSE_BUILDER, List.class.getName()), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Vary")),
    RESPONSE_BUILDER_VARIANTS_ARRAY(MethodIdentifier.ofNonStatic(KnownNames.RESPONSE_BUILDER, "variants", KnownNames.RESPONSE_BUILDER, KnownNames.VARIANT + "[]"), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Vary")),
    RESPONSE_STATUS_ENUM(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "status", KnownNames.RESPONSE_BUILDER, KnownNames.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_STATUS_INT(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "status", KnownNames.RESPONSE_BUILDER, "int"), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_OK(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "ok", KnownNames.RESPONSE_BUILDER, new String[0]), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
    }),
    RESPONSE_OK_ENTITY(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "ok", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_OK_VARIANT(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "ok", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT, KnownNames.VARIANT), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
        KnownResponseResultMethod.addHeader(object, "Content-Language");
        return KnownResponseResultMethod.addHeader(object, "Content-Encoding");
    }),
    RESPONSE_OK_MEDIATYPE(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "ok", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT, MediaType.class.getName()), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(m -> (MediaType)m).map(m -> m.getType() + '/' + m.getSubtype()).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_OK_MEDIATYPE_STRING(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "ok", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT, KnownNames.STRING), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(t -> (String)t).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_ACCEPTED(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "accepted", KnownNames.RESPONSE_BUILDER, new String[0]), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.ACCEPTED.getStatusCode());
    }),
    RESPONSE_ACCEPTED_ENTITY(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "accepted", KnownNames.RESPONSE_BUILDER, KnownNames.OBJECT), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.ACCEPTED.getStatusCode());
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_CREATED(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "created", KnownNames.RESPONSE_BUILDER, KnownNames.URI), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.CREATED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_NO_CONTENT(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "noContent", KnownNames.RESPONSE_BUILDER, new String[0]), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.NO_CONTENT.getStatusCode());
    }),
    RESPONSE_NOT_ACCEPTABLE(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "notAcceptable", KnownNames.RESPONSE_BUILDER, "java.util.List"), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_ACCEPTABLE.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Vary");
    }),
    RESPONSE_NOT_MODIFIED(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "notModified", KnownNames.RESPONSE_BUILDER, new String[0]), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
    }),
    RESPONSE_NOT_MODIFIED_ENTITYTAG(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "notModified", KnownNames.RESPONSE_BUILDER, EntityTag.class.getName()), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "ETag");
    }),
    RESPONSE_NOT_MODIFIED_ENTITYTAG_STRING(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "notModified", KnownNames.RESPONSE_BUILDER, KnownNames.STRING), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "ETag");
    }),
    RESPONSE_SEE_OTHER(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "seeOther", KnownNames.RESPONSE_BUILDER, KnownNames.URI), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.SEE_OTHER.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_TEMPORARY_REDIRECT(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "temporaryRedirect", KnownNames.RESPONSE_BUILDER, KnownNames.URI), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_SERVER_ERROR(MethodIdentifier.ofStatic(KnownNames.RESPONSE, "serverError", KnownNames.RESPONSE_BUILDER, new String[0]), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_EMPTY(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, new String[0]), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_RESPONSE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(0)),
    WEB_APPLICATION_EXCEPTION_MESSAGE_RESPONSE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, KnownNames.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(1)),
    WEB_APPLICATION_EXCEPTION_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, "int"), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, "int"), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, KnownNames.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.THROWABLE), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, KnownNames.THROWABLE), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE_RESPONSE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.THROWABLE, KnownNames.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(1)),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_RESPONSE(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, KnownNames.THROWABLE, KnownNames.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(2)),
    WEB_APPLICATION_EXCEPTION_CAUSE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.THROWABLE, "int"), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, KnownNames.THROWABLE, "int"), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(2)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.THROWABLE, KnownNames.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(KnownNames.WEB_APPLICATION_EXCEPTION, "<init>", null, KnownNames.STRING, KnownNames.THROWABLE, KnownNames.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(KnownNames.HTTP_RESPONSE, new HttpResponse());
        ((Element)arguments.get(2)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESOURCE_CONTEXT_INIT(MethodIdentifier.ofNonStatic(KnownNames.RESOURCE_CONTEXT, "getResource", KnownNames.OBJECT, "java.lang.Class"), (object, arguments) -> new Element(((Element)arguments.get(0)).getPossibleValues().stream().map(c -> (String)c).findFirst().orElse(KnownNames.OBJECT), new Object[0])),
    RESOURCE_CONTEXT_GET(MethodIdentifier.ofNonStatic(KnownNames.RESOURCE_CONTEXT, "initResource", KnownNames.OBJECT, KnownNames.OBJECT), (object, arguments) -> new Element(((Element)arguments.get(0)).getType(), new Object[0])),
    INTEGER_VALUE_OF(MethodIdentifier.ofStatic(KnownNames.INTEGER, "valueOf", KnownNames.INTEGER, "int"), (object, arguments) -> new Element(Integer.TYPE.getCanonicalName(), ((Element)arguments.get(0)).getPossibleValues().toArray())),
    LIST_STREAM(MethodIdentifier.ofNonStatic(List.class.getName(), "stream", KnownNames.STREAM, new String[0]), (object, arguments) -> new Element(JavaUtils.trimCollection(object.getType()), new Object[0])),
    SET_STREAM(MethodIdentifier.ofNonStatic(Set.class.getName(), "stream", KnownNames.STREAM, new String[0]), (object, arguments) -> new Element(JavaUtils.trimCollection(object.getType()), new Object[0])),
    STREAM_COLLECT(MethodIdentifier.ofNonStatic(KnownNames.STREAM, "collect", KnownNames.OBJECT, KnownNames.SUPPLIER, KnownNames.BI_CONSUMER, KnownNames.BI_CONSUMER), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle && arguments.get(1) instanceof MethodHandle) {
            Element collectionElement = ((Method)arguments.get(0)).invoke(null, Collections.emptyList());
            return ((Method)arguments.get(1)).invoke(null, Arrays.asList(collectionElement, object));
        }
        return Element.EMPTY;
    }),
    STREAM_FOR_EACH(MethodIdentifier.ofNonStatic(KnownNames.STREAM, "forEach", null, KnownNames.CONSUMER), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    STREAM_MAP(MethodIdentifier.ofNonStatic(KnownNames.STREAM, "map", KnownNames.STREAM, Function.class.getName()), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            return ((MethodHandle)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return Element.EMPTY;
    });

    private final MethodIdentifier identifier;
    private final BiFunction<Element, List<Element>, Element> function;

    private KnownResponseResultMethod(MethodIdentifier identifier, BiFunction<Element, List<Element>, Element> function) {
        this.identifier = identifier;
        this.function = function;
    }

    @Override
    public Element invoke(Element object, List<Element> arguments) {
        if (arguments.size() != this.identifier.getParameterTypes().length) {
            throw new IllegalArgumentException("Method arguments do not match expected signature!");
        }
        return this.function.apply(object, arguments);
    }

    @Override
    public boolean matches(MethodIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    private static Element addHeader(Element object, String header) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getHeaders().add(header));
        return object;
    }

    private static Element addEntity(Element object, Element argument) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> {
            r.getEntityTypes().add(argument.getType());
            argument.getPossibleValues().stream().filter(j -> j instanceof JsonValue).map(j -> (JsonValue)j).forEach(j -> r.getInlineEntities().add((JsonValue)j));
        });
        return object;
    }

    private static Element addStatus(Element object, Integer status) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getStatuses().add(status));
        return object;
    }

    private static Element addContentType(Element object, String type) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getContentTypes().add(type));
        return object;
    }

    static class KnownNames {
        static final String HTTP_RESPONSE = HttpResponse.class.getName();
        static final String RESPONSE_BUILDER = Response.ResponseBuilder.class.getName();
        static final String RESPONSE = Response.class.getName();
        static final String RESPONSE_STATUS = Response.Status.class.getName();
        static final String RESOURCE_CONTEXT = ResourceContext.class.getName();
        static final String OBJECT = Object.class.getName();
        static final String STRING = String.class.getName();
        static final String INTEGER = Integer.class.getName();
        static final String URI = URI.class.getName();
        static final String DATE = Date.class.getName();
        static final String VARIANT = Variant.class.getName();
        static final String STREAM = Stream.class.getName();
        static final String SUPPLIER = Supplier.class.getName();
        static final String BI_CONSUMER = BiConsumer.class.getName();
        static final String CONSUMER = Consumer.class.getName();
        static final String WEB_APPLICATION_EXCEPTION = WebApplicationException.class.getName();
        static final String THROWABLE = Throwable.class.getName();

        KnownNames() {
        }
    }
}

