/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.MethodHandle;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetFieldInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.GetStaticInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeDynamicInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.NewInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.PushInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.SizeChangingInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.StoreInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class MethodSimulator {
    private final Lock lock = new ReentrantLock();
    private final MethodPool methodPool = MethodPool.getInstance();
    private final Stack<Element> runtimeStack = new Stack();
    protected Map<Integer, Element> localVariables = new HashMap<Integer, Element>();
    private Element returnElement;

    public Element simulate(List<Instruction> instructions) {
        this.lock.lock();
        try {
            this.returnElement = null;
            Element element = this.simulateInternal(instructions);
            return element;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected Element simulateInternal(List<Instruction> instructions) {
        instructions.stream().forEach(this::simulate);
        return this.returnElement;
    }

    private void simulate(Instruction instruction) {
        switch (instruction.getType()) {
            case PUSH: {
                Object value = ((PushInstruction)instruction).getValue();
                this.runtimeStack.push(new Element(value.getClass().getCanonicalName(), value));
                break;
            }
            case METHOD_HANDLE: {
                this.simulateMethodHandle((InvokeDynamicInstruction)instruction);
                break;
            }
            case INVOKE: {
                this.simulateInvoke((InvokeInstruction)instruction);
                break;
            }
            case GET_FIELD: {
                this.runtimeStack.pop();
                this.runtimeStack.push(new Element(((GetFieldInstruction)instruction).getPropertyType(), new Object[0]));
                break;
            }
            case GET_STATIC: {
                this.simulateGetStatic((GetStaticInstruction)instruction);
                break;
            }
            case LOAD: {
                LoadInstruction loadInstruction = (LoadInstruction)instruction;
                this.runtimeStack.push(this.localVariables.getOrDefault(loadInstruction.getNumber(), new Element(loadInstruction.getVariableType(), new Object[0])));
                break;
            }
            case STORE: {
                this.simulateStore((StoreInstruction)instruction);
                break;
            }
            case SIZE_CHANGE: {
                this.simulateSizeChange((SizeChangingInstruction)instruction);
                break;
            }
            case NEW: {
                NewInstruction newInstruction = (NewInstruction)instruction;
                this.runtimeStack.push(new Element(newInstruction.getCreatedType(), new Object[0]));
                break;
            }
            case DUP: {
                this.runtimeStack.push(this.runtimeStack.peek());
                break;
            }
            case OTHER: {
                break;
            }
            case RETURN: {
                this.mergeReturnElement(this.runtimeStack.pop());
            }
            case THROW: {
                this.mergePossibleResponse();
                this.runtimeStack.clear();
                break;
            }
            default: {
                throw new IllegalArgumentException("Instruction without type!");
            }
        }
    }

    private void simulateMethodHandle(InvokeDynamicInstruction instruction) {
        List<Element> arguments = Stream.of(instruction.getDynamicIdentifier().getParameterTypes()).map(t -> this.runtimeStack.pop()).collect(Collectors.toList());
        Collections.reverse(arguments);
        if (!instruction.getDynamicIdentifier().isStaticMethod()) {
            arguments.remove(0);
        }
        this.runtimeStack.push(new MethodHandle(instruction.getDynamicIdentifier().getReturnType(), instruction.getIdentifier(), arguments));
    }

    private void simulateInvoke(InvokeInstruction instruction) {
        LinkedList<Element> arguments = new LinkedList<Element>();
        MethodIdentifier identifier = instruction.getIdentifier();
        Stream.of(identifier.getParameterTypes()).forEachOrdered(t -> arguments.add(this.runtimeStack.pop()));
        Collections.reverse(arguments);
        Element object = null;
        Method method = !identifier.isStaticMethod() ? ((object = this.runtimeStack.pop()) instanceof MethodHandle ? (Method)((Object)object) : this.methodPool.get(identifier)) : this.methodPool.get(identifier);
        Element returnedElement = method.invoke(object, arguments);
        if (returnedElement != null) {
            this.runtimeStack.push(returnedElement);
        }
    }

    private void simulateGetStatic(GetStaticInstruction instruction) {
        try {
            Field field = Class.forName(instruction.getClassName()).getField(instruction.getPropertyName());
            this.runtimeStack.push(new Element(field.getType().getCanonicalName(), field.get(null)));
        }
        catch (ReflectiveOperationException e) {
            LogProvider.getLogger().accept("Could not access static property, reason: " + e.getMessage());
            this.runtimeStack.push(Element.EMPTY);
        }
    }

    private void simulateStore(StoreInstruction instruction) {
        int index = instruction.getNumber();
        Element elementToStore = this.runtimeStack.pop();
        if (elementToStore instanceof MethodHandle) {
            this.mergeMethodHandleStore(index, (MethodHandle)elementToStore);
        } else {
            this.mergeElementStore(index, instruction.getVariableType(), elementToStore);
        }
    }

    private void mergeElementStore(int index, String variableType, Element element) {
        Element created = new Element(JavaUtils.determineMoreSpecificType(element.getType(), variableType), new Object[0]);
        created.merge(element);
        this.localVariables.merge(index, created, Element::merge);
    }

    private void mergeMethodHandleStore(int index, MethodHandle methodHandle) {
        this.localVariables.merge(index, new MethodHandle(methodHandle), Element::merge);
    }

    private void mergePossibleResponse() {
        if (!this.runtimeStack.isEmpty() && HttpResponse.class.getName().equals(this.runtimeStack.peek().getType())) {
            this.mergeReturnElement(this.runtimeStack.peek());
        }
    }

    private void simulateSizeChange(SizeChangingInstruction instruction) {
        IntStream.range(0, instruction.getNumberOfPops()).forEach(i -> this.runtimeStack.pop());
        IntStream.range(0, instruction.getNumberOfPushes()).forEach(i -> this.runtimeStack.push(Element.EMPTY));
    }

    private void mergeReturnElement(Element stackElement) {
        if (this.returnElement != null) {
            stackElement.merge(this.returnElement);
        }
        this.returnElement = stackElement;
    }
}

