/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.HttpMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Consumer;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Consumes;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;

public final class AnnotationInterpreter {
    private AnnotationInterpreter() {
        throw new UnsupportedOperationException();
    }

    public static void interpretClassAnnotation(Object annotation, ClassResult result) {
        AnnotationInterpreter.consumeIfMatches(annotation, ApplicationPath.class, applicationPath -> result.setApplicationPath(applicationPath.value()));
        AnnotationInterpreter.consumeIfMatches(annotation, Path.class, path -> result.setResourcePath(path.value()));
        AnnotationInterpreter.consumeIfMatches(annotation, Consumes.class, consumes -> result.getRequestMediaTypes().addAll(Arrays.asList(consumes.value())));
        AnnotationInterpreter.consumeIfMatches(annotation, Produces.class, produces -> result.getResponseMediaTypes().addAll(Arrays.asList(produces.value())));
    }

    public static void interpretMethodAnnotation(Object annotation, MethodResult result) {
        AnnotationInterpreter.consumeIfMatches(annotation, Path.class, path -> result.setPath(path.value()));
        AnnotationInterpreter.consumeIfMatches(annotation, GET.class, m -> result.setHttpMethod(HttpMethod.GET));
        AnnotationInterpreter.consumeIfMatches(annotation, PUT.class, m -> result.setHttpMethod(HttpMethod.PUT));
        AnnotationInterpreter.consumeIfMatches(annotation, POST.class, m -> result.setHttpMethod(HttpMethod.POST));
        AnnotationInterpreter.consumeIfMatches(annotation, DELETE.class, m -> result.setHttpMethod(HttpMethod.DELETE));
        AnnotationInterpreter.consumeIfMatches(annotation, HEAD.class, m -> result.setHttpMethod(HttpMethod.HEAD));
        AnnotationInterpreter.consumeIfMatches(annotation, OPTIONS.class, m -> result.setHttpMethod(HttpMethod.OPTIONS));
        AnnotationInterpreter.consumeIfMatches(annotation, Consumes.class, consumes -> result.getRequestMediaTypes().addAll(Arrays.asList(consumes.value())));
        AnnotationInterpreter.consumeIfMatches(annotation, Produces.class, produces -> result.getResponseMediaTypes().addAll(Arrays.asList(produces.value())));
    }

    public static void interpretMethodParameterAnnotation(Object annotation, String annotatedType, MethodResult result) {
        AnnotationInterpreter.consumeIfMatches(annotation, MatrixParam.class, m -> result.getMethodParameters().getMatrixParams().put(m.value(), annotatedType));
        AnnotationInterpreter.consumeIfMatches(annotation, QueryParam.class, m -> result.getMethodParameters().getQueryParams().put(m.value(), annotatedType));
        AnnotationInterpreter.consumeIfMatches(annotation, PathParam.class, m -> result.getMethodParameters().getPathParams().put(m.value(), annotatedType));
        AnnotationInterpreter.consumeIfMatches(annotation, CookieParam.class, m -> result.getMethodParameters().getCookieParams().put(m.value(), annotatedType));
        AnnotationInterpreter.consumeIfMatches(annotation, HeaderParam.class, m -> result.getMethodParameters().getHeaderParams().put(m.value(), annotatedType));
        AnnotationInterpreter.consumeIfMatches(annotation, FormParam.class, m -> result.getMethodParameters().getFormParams().put(m.value(), annotatedType));
    }

    public static void interpretFieldAnnotation(Object annotation, String annotatedType, Set<MethodResult> results) {
        AnnotationInterpreter.consumeIfMatches(annotation, MatrixParam.class, m -> results.stream().forEach(r -> r.getMethodParameters().getMatrixParams().put(m.value(), annotatedType)));
        AnnotationInterpreter.consumeIfMatches(annotation, QueryParam.class, m -> results.stream().forEach(r -> r.getMethodParameters().getQueryParams().put(m.value(), annotatedType)));
        AnnotationInterpreter.consumeIfMatches(annotation, PathParam.class, m -> results.stream().forEach(r -> r.getMethodParameters().getPathParams().put(m.value(), annotatedType)));
        AnnotationInterpreter.consumeIfMatches(annotation, CookieParam.class, m -> results.stream().forEach(r -> r.getMethodParameters().getCookieParams().put(m.value(), annotatedType)));
        AnnotationInterpreter.consumeIfMatches(annotation, HeaderParam.class, m -> results.stream().forEach(r -> r.getMethodParameters().getHeaderParams().put(m.value(), annotatedType)));
        AnnotationInterpreter.consumeIfMatches(annotation, FormParam.class, m -> results.stream().forEach(r -> r.getMethodParameters().getFormParams().put(m.value(), annotatedType)));
    }

    private static <T> void consumeIfMatches(Object object, Class<T> clazz, Consumer<T> consumer) {
        if (clazz.isAssignableFrom(object.getClass())) {
            consumer.accept(object);
        }
    }
}

