/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.classes;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.AnnotationInterpreter;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javax.ws.rs.ApplicationPath;
import javax.ws.rs.Path;

public class ClassAnalyzer {
    private static final Class<?>[] RELEVANT_CLASS_ANNOTATIONS = new Class[]{ApplicationPath.class, Path.class};
    private final Lock lock = new ReentrantLock();
    private CtClass ctClass;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassResult analyze(CtClass ctClass) {
        this.lock.lock();
        try {
            this.ctClass = ctClass;
            if (ctClass == null || !this.isRelevant()) {
                ClassResult classResult = null;
                return classResult;
            }
            ClassResult classResult = new ClassResult();
            this.analyzeAnnotations(classResult);
            this.analyzeInternal(classResult);
            ClassResult classResult2 = classResult;
            return classResult2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void analyzeSubResource(CtClass ctClass, ClassResult classResult) {
        try {
            this.lock.lock();
            this.ctClass = ctClass;
            if (ctClass == null) {
                return;
            }
            this.analyzeInternal(classResult);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void analyzeAnnotations(ClassResult classResult) {
        for (Object annotation : this.ctClass.getAvailableAnnotations()) {
            AnnotationInterpreter.interpretClassAnnotation(annotation, classResult);
        }
    }

    private void analyzeInternal(ClassResult classResult) {
        if (classResult.getApplicationPath() != null) {
            return;
        }
        MethodAnalyzer methodAnalyzer = new MethodAnalyzer();
        Stream.of(this.ctClass.getMethods()).map(methodAnalyzer::analyze).filter(Objects::nonNull).forEach(classResult::add);
        this.analyzeFields(classResult);
    }

    private boolean isRelevant() {
        for (Object annotation : this.ctClass.getAvailableAnnotations()) {
            if (!Stream.of(RELEVANT_CLASS_ANNOTATIONS).anyMatch(c -> c.isAssignableFrom(annotation.getClass()))) continue;
            return true;
        }
        return false;
    }

    private void analyzeFields(ClassResult classResult) {
        for (CtField ctField : this.ctClass.getDeclaredFields()) {
            try {
                String fieldType = ctField.getType().getName();
                Stream.of(ctField.getAnnotations()).forEach(a -> AnnotationInterpreter.interpretFieldAnnotation(a, fieldType, classResult.getMethods()));
            }
            catch (ClassNotFoundException | NotFoundException e) {
                LogProvider.getLogger().accept("Could not analyze class field " + e.getMessage());
            }
        }
    }
}

