/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javassist.CtMethod;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import javax.ws.rs.core.Response;

class ResourceMethodContentAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final MethodSimulator methodSimulator = new MethodSimulator();

    ResourceMethodContentAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(CtMethod method, MethodResult result) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(method);
            List<Instruction> visitedInstructions = this.interpretRelevantInstructions(method);
            Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
            projectMethods.stream().forEach(MethodPool.getInstance()::addProjectMethod);
            Element returnedElement = this.methodSimulator.simulate(visitedInstructions);
            String returnType = ResourceMethodContentAnalyzer.determineReturnType(method);
            if (returnedElement == null) {
                return;
            }
            Set possibleObjects = returnedElement.getPossibleValues().stream().filter(o -> !(o instanceof HttpResponse)).collect(Collectors.toSet());
            if (!Response.class.getName().equals(returnType)) {
                HttpResponse defaultResponse = new HttpResponse();
                defaultResponse.getEntityTypes().add(Object.class.getName().equals(returnType) ? returnedElement.getType() : returnType);
                possibleObjects.stream().filter(o -> o instanceof JsonValue).map(o -> (JsonValue)o).forEach(defaultResponse.getInlineEntities()::add);
                result.getResponses().add(defaultResponse);
            }
            returnedElement.getPossibleValues().stream().filter(o -> o instanceof HttpResponse).map(o -> (HttpResponse)o).forEach(result.getResponses()::add);
        }
        finally {
            this.lock.unlock();
        }
    }

    private static String determineReturnType(CtMethod method) {
        try {
            String sig = method.getGenericSignature() != null ? method.getGenericSignature() : method.getSignature();
            return SignatureAttribute.toMethodSignature(sig).getReturnType().toString();
        }
        catch (BadBytecode e) {
            throw new IllegalArgumentException(e);
        }
    }
}

