/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import java.util.stream.Stream;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

final class JsonMapper {
    private JsonMapper() {
        throw new UnsupportedOperationException();
    }

    static javax.json.JsonValue map(JsonValue jsonValue) {
        if (jsonValue instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray) {
            return JsonMapper.map((com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray)jsonValue);
        }
        return JsonMapper.map((com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject)jsonValue);
    }

    private static JsonArray map(com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray jsonArray) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        jsonArray.getElements().stream().forEach(e -> JsonMapper.addToArray(builder, e));
        return builder.build();
    }

    private static void addToArray(JsonArrayBuilder builder, Element value) {
        switch (value.getType()) {
            case "java.lang.String": {
                builder.add("string");
                break;
            }
            case "java.lang.Integer": 
            case "int": 
            case "java.math.BigInteger": 
            case "java.math.BigDecimal": 
            case "java.lang.Long": 
            case "long": {
                builder.add(0);
                break;
            }
            case "java.lang.Double": 
            case "double": {
                builder.add(0.0);
                break;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                builder.add(false);
                break;
            }
            case "javax.json.JsonValue": 
            case "javax.json.JsonArray": 
            case "javax.json.JsonObject": {
                value.getPossibleValues().stream().filter(v -> v instanceof JsonValue).findFirst().ifPresent(v -> builder.add(JsonMapper.map((JsonValue)v)));
                break;
            }
            default: {
                builder.addNull();
            }
        }
    }

    private static JsonObject map(com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject jsonObject) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        jsonObject.getStructure().entrySet().stream().forEach(e -> JsonMapper.addToObject(builder, (String)e.getKey(), (Element)e.getValue()));
        return builder.build();
    }

    private static void addToObject(JsonObjectBuilder builder, String key, Element value) {
        String[] jsonTypes = new String[]{"javax.json.JsonValue", "javax.json.JsonArray", "javax.json.JsonObject"};
        if (Stream.of(jsonTypes).anyMatch(t -> t.equals(value.getType()))) {
            value.getPossibleValues().stream().filter(v -> v instanceof JsonValue).findFirst().ifPresent(v -> builder.add(key, JsonMapper.map((JsonValue)v)));
            return;
        }
        JsonMapper.addToObject(builder, key, value.getType());
    }

    static void addToObject(JsonObjectBuilder builder, String key, String type) {
        switch (type) {
            case "java.lang.String": {
                builder.add(key, "string");
                break;
            }
            case "java.lang.Integer": 
            case "int": 
            case "java.lang.Long": 
            case "long": 
            case "java.math.BigInteger": {
                builder.add(key, 0);
                break;
            }
            case "java.lang.Double": 
            case "double": 
            case "java.math.BigDecimal": {
                builder.add(key, 0.0);
                break;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                builder.add(key, false);
                break;
            }
            default: {
                builder.addNull(key);
            }
        }
    }
}

