/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.ResponseTypeNormalizer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.Pair;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.lang.reflect.Modifier;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

class TypeAnalyzer {
    private static final String[] NAMES_TO_IGNORE = new String[]{"getClass"};
    private static final JsonString EMPTY_JSON_STRING = new JsonString(){
        private static final String TYPE = "string";

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.STRING;
        }

        @Override
        public String getString() {
            return TYPE;
        }

        @Override
        public CharSequence getChars() {
            return TYPE;
        }
    };
    private final Lock lock = new ReentrantLock();
    private String type;
    private boolean collection;

    TypeAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeRepresentation analyze(String type) {
        this.lock.lock();
        try {
            this.collection = JavaUtils.isCollection(type);
            this.type = ResponseTypeNormalizer.normalizeWrapper(type);
            if (!this.isRelevant()) {
                TypeRepresentation typeRepresentation = new TypeRepresentation(this.type);
                return typeRepresentation;
            }
            TypeRepresentation representation = new TypeRepresentation(ResponseTypeNormalizer.normalize(this.type));
            representation.getRepresentations().put("application/json", TypeAnalyzer.analyzeInternal(this.type));
            TypeRepresentation typeRepresentation = representation;
            return typeRepresentation;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isRelevant() {
        return this.collection || !this.type.startsWith("java");
    }

    private static JsonValue analyzeInternal(String type) {
        if (JavaUtils.isCollection(type)) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            TypeAnalyzer.addToArray(arrayBuilder, JavaUtils.trimCollection(type));
            return arrayBuilder.build();
        }
        try {
            CtClass ctClass = ClassPool.getDefault().get(type);
            return TypeAnalyzer.analyzeClass(ctClass);
        }
        catch (ClassNotFoundException | NotFoundException e) {
            LogProvider.getLogger().accept("Could not analyze class for type analysis: " + e.getMessage());
            return Json.createObjectBuilder().build();
        }
    }

    private static JsonValue analyzeClass(CtClass ctClass) throws ClassNotFoundException {
        if (ctClass.isEnum()) {
            return EMPTY_JSON_STRING;
        }
        XmlAccessType value = ctClass.hasAnnotation(XmlAccessorType.class) ? ((XmlAccessorType)ctClass.getAnnotation(XmlAccessorType.class)).value() : XmlAccessType.PUBLIC_MEMBER;
        List relevantFields = Stream.of(ctClass.getDeclaredFields()).filter(f -> TypeAnalyzer.isRelevant(f, value)).collect(Collectors.toList());
        List relevantGetters = Stream.of(ctClass.getDeclaredMethods()).filter(m -> TypeAnalyzer.isRelevant(m, value)).collect(Collectors.toList());
        JsonObjectBuilder builder = Json.createObjectBuilder();
        relevantFields.stream().map(TypeAnalyzer::mapField).filter(Objects::nonNull).forEach(p -> TypeAnalyzer.addToObject(builder, (String)p.getLeft(), (String)p.getRight()));
        relevantGetters.stream().map(TypeAnalyzer::mapGetter).filter(Objects::nonNull).forEach(p -> TypeAnalyzer.addToObject(builder, (String)p.getLeft(), (String)p.getRight()));
        return builder.build();
    }

    private static boolean isRelevant(CtField field, XmlAccessType accessType) {
        int modifiers = field.getModifiers();
        if (field.hasAnnotation(XmlElement.class)) {
            return true;
        }
        if (accessType == XmlAccessType.FIELD) {
            return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !field.hasAnnotation(XmlTransient.class);
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !field.hasAnnotation(XmlTransient.class);
        }
        return false;
    }

    private static boolean isRelevant(CtMethod method, XmlAccessType accessType) {
        if (!TypeAnalyzer.isGetter(method)) {
            return false;
        }
        if (method.hasAnnotation(XmlElement.class)) {
            return true;
        }
        if (accessType == XmlAccessType.PROPERTY) {
            return !method.hasAnnotation(XmlTransient.class);
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(method.getModifiers()) && !method.hasAnnotation(XmlTransient.class);
        }
        return false;
    }

    private static boolean isGetter(CtMethod method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        String name = method.getName();
        if (Stream.of(NAMES_TO_IGNORE).anyMatch(n -> n.equals(name))) {
            return false;
        }
        if (name.startsWith("get") && name.length() > 3) {
            return !method.getSignature().endsWith(")V");
        }
        return name.startsWith("is") && name.length() > 2 && method.getSignature().endsWith(")Z");
    }

    private static Pair<String, String> mapField(CtField field) {
        try {
            String sig = field.getGenericSignature() != null ? field.getGenericSignature() : field.getSignature();
            String fieldType = JavaUtils.getType(SignatureAttribute.toTypeSignature(sig));
            return Pair.of(field.getName(), fieldType);
        }
        catch (BadBytecode e) {
            LogProvider.getLogger().accept("Could not analyze field: " + field);
            return null;
        }
    }

    private static Pair<String, String> mapGetter(CtMethod method) {
        try {
            String sig = method.getGenericSignature() != null ? method.getGenericSignature() : method.getSignature();
            String returnType = JavaUtils.getType(SignatureAttribute.toMethodSignature(sig).getReturnType());
            return Pair.of(TypeAnalyzer.normalizeGetter(method.getName()), returnType);
        }
        catch (BadBytecode e) {
            LogProvider.getLogger().accept("Could not analyze method: " + method);
            return null;
        }
    }

    private static String normalizeGetter(String name) {
        int size = name.startsWith("is") ? 2 : 3;
        char[] chars = name.substring(size).toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static void addToObject(JsonObjectBuilder builder, String key, String type) {
        if (type.startsWith("java.time")) {
            builder.add(key, "date");
            return;
        }
        switch (type) {
            case "java.lang.String": {
                builder.add(key, "string");
                break;
            }
            case "java.util.Date": {
                builder.add(key, "date");
                break;
            }
            case "java.lang.Integer": 
            case "int": 
            case "java.lang.Long": 
            case "long": 
            case "java.math.BigInteger": {
                builder.add(key, 0);
                break;
            }
            case "java.lang.Double": 
            case "double": 
            case "java.math.BigDecimal": {
                builder.add(key, 0.0);
                break;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                builder.add(key, false);
                break;
            }
            default: {
                builder.add(key, TypeAnalyzer.analyzeInternal(type));
            }
        }
    }

    private static void addToArray(JsonArrayBuilder builder, String type) {
        switch (type) {
            case "java.lang.String": {
                builder.add("string");
                break;
            }
            case "java.lang.Integer": 
            case "int": 
            case "java.lang.Long": 
            case "long": 
            case "java.math.BigInteger": {
                builder.add(0);
                break;
            }
            case "java.lang.Double": 
            case "double": 
            case "java.math.BigDecimal": {
                builder.add(0.0);
                break;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                builder.add(false);
                break;
            }
            default: {
                builder.add(TypeAnalyzer.analyzeInternal(type));
            }
        }
    }
}

