/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.utils;

import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import java.util.List;
import java.util.Set;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public final class JavaUtils {
    public static final String INITIALIZER_NAME = "<init>";
    public static final String BOOTSTRAP_ATTRIBUTE_NAME = "BootstrapMethods";
    private static final String OBJECT = Object.class.getName();
    private static final String LIST = List.class.getName();
    private static final String LIST_SEARCH = "List<";
    private static final String SET = Set.class.getName();
    private static final String SET_SEARCH = "Set<";

    private JavaUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isInitializerName(String name) {
        return INITIALIZER_NAME.equals(name);
    }

    public static CtClass[] getParameterClasses(MethodIdentifier identifier) throws NotFoundException {
        CtClass[] parameterClasses = new CtClass[identifier.getParameterTypes().length];
        for (int i = 0; i < parameterClasses.length; ++i) {
            parameterClasses[i] = ClassPool.getDefault().get(identifier.getParameterTypes()[i]);
        }
        return parameterClasses;
    }

    public static String getMethodReturnType(SignatureAttribute.MethodSignature signature) throws BadBytecode {
        String type = JavaUtils.getType(signature.getReturnType());
        if ("void".equals(type)) {
            return null;
        }
        return type;
    }

    public static String[] getMethodParameters(SignatureAttribute.MethodSignature signature) throws BadBytecode {
        SignatureAttribute.Type[] parameterTypes = signature.getParameterTypes();
        String[] parameters = new String[parameterTypes.length];
        int index = 0;
        for (SignatureAttribute.Type type : parameterTypes) {
            parameters[index++] = JavaUtils.getType(type);
        }
        return parameters;
    }

    public static String getType(SignatureAttribute.Type type) {
        if (type instanceof SignatureAttribute.NestedClassType) {
            SignatureAttribute.NestedClassType nestedClassType = (SignatureAttribute.NestedClassType)type;
            return nestedClassType.getDeclaringClass().getName() + '$' + nestedClassType.getName();
        }
        return type.toString();
    }

    public static boolean isCollection(String type) {
        return type.contains(LIST_SEARCH) || type.contains(SET_SEARCH) || LIST.equals(type) || SET.equals(type);
    }

    public static String trimCollection(String type) {
        int foundIndex = type.indexOf(LIST_SEARCH);
        if (foundIndex != -1) {
            int startIndex = foundIndex + LIST_SEARCH.length();
            int occurrences = (int)type.substring(0, startIndex).chars().filter(c -> c == 60).count();
            return type.substring(startIndex, type.length() - occurrences);
        }
        foundIndex = type.indexOf(SET_SEARCH);
        if (foundIndex != -1) {
            int startIndex = foundIndex + SET_SEARCH.length();
            int occurrences = (int)type.substring(0, startIndex).chars().filter(c -> c == 60).count();
            return type.substring(startIndex, type.length() - occurrences);
        }
        if (LIST.equals(type) || SET.equals(type)) {
            return OBJECT;
        }
        return type;
    }

    public static String determineMoreSpecificType(String firstType, String secondType) {
        if (OBJECT.equals(secondType) || firstType.equals(secondType)) {
            return firstType;
        }
        boolean firstTypeParameterized = firstType.contains("<");
        boolean secondTypeParameterized = secondType.contains("<");
        if (firstTypeParameterized || secondTypeParameterized) {
            if (firstTypeParameterized && !secondTypeParameterized) {
                return firstType;
            }
            if (!firstTypeParameterized) {
                return secondType;
            }
            return firstType.length() >= secondType.length() ? firstType : secondType;
        }
        boolean firstTypeArray = firstType.contains("[");
        boolean secondTypeArray = secondType.contains("[");
        if (firstTypeArray || secondTypeArray) {
            if (firstTypeArray && !secondTypeArray) {
                return firstType;
            }
            if (!firstTypeArray) {
                return secondType;
            }
        }
        return firstType;
    }
}

