/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerType;
import javax.json.JsonValue;

final class SwaggerUtils {
    private SwaggerUtils() {
        throw new UnsupportedOperationException();
    }

    static SwaggerType toSwaggerType(String type) {
        switch (type) {
            case "java.lang.Integer": 
            case "int": 
            case "java.lang.Long": 
            case "long": {
                return SwaggerType.INTEGER;
            }
            case "java.lang.Double": 
            case "double": 
            case "java.lang.Float": 
            case "float": {
                return SwaggerType.NUMBER;
            }
            case "java.lang.Boolean": 
            case "boolean": {
                return SwaggerType.BOOLEAN;
            }
            case "java.lang.String": {
                return SwaggerType.STRING;
            }
        }
        if (type.contains("[")) {
            return SwaggerType.ARRAY;
        }
        return SwaggerType.OBJECT;
    }

    static SwaggerType toSwaggerType(JsonValue.ValueType type) {
        switch (type) {
            case ARRAY: {
                return SwaggerType.ARRAY;
            }
            case OBJECT: {
                return SwaggerType.OBJECT;
            }
            case STRING: {
                return SwaggerType.STRING;
            }
            case NUMBER: {
                return SwaggerType.NUMBER;
            }
            case TRUE: 
            case FALSE: {
                return SwaggerType.BOOLEAN;
            }
            case NULL: {
                return SwaggerType.NULL;
            }
        }
        return null;
    }
}

