/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.elements;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Element {
    public static final Element EMPTY = new UnmodifiableElement(Object.class.getName());
    private final Set<Object> possibleValues;
    private final String type;

    public Element(String type, Object ... values) {
        Objects.requireNonNull(type);
        this.type = type;
        this.possibleValues = new HashSet<Object>();
        if (values == null) {
            this.possibleValues.add(null);
        } else {
            Collections.addAll(this.possibleValues, values);
        }
    }

    public Element merge(Element element) {
        this.possibleValues.addAll(element.possibleValues);
        return this;
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public String getType() {
        return this.type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        if (!this.possibleValues.equals(element.possibleValues)) {
            return false;
        }
        return this.type.equals(element.type);
    }

    public int hashCode() {
        int result = this.possibleValues.hashCode();
        result = 31 * result + this.type.hashCode();
        return result;
    }

    public String toString() {
        return "Element{possibleValues=" + this.possibleValues + ", type='" + this.type + '\'' + '}';
    }

    private static class UnmodifiableElement
    extends Element {
        public UnmodifiableElement(String type) {
            super(type, new Object[0]);
        }

        @Override
        public Set<Object> getPossibleValues() {
            return Collections.unmodifiableSet(super.getPossibleValues());
        }
    }
}

