/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;

public abstract class GetPropertyInstruction
implements Instruction {
    private final String className;
    private final String propertyName;
    private final String propertyType;

    protected GetPropertyInstruction(String className, String propertyName, String propertyType) {
        this.className = className;
        this.propertyName = propertyName;
        this.propertyType = propertyType;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPropertyInstruction that = (GetPropertyInstruction)o;
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.propertyName != null ? !this.propertyName.equals(that.propertyName) : that.propertyName != null) {
            return false;
        }
        if (this.propertyType != null ? !this.propertyType.equals(that.propertyType) : that.propertyType != null) {
            return false;
        }
        if (this.getStackSizeDifference() != that.getStackSizeDifference()) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.className != null ? this.className.hashCode() : 0;
        result = 31 * result + this.getStackSizeDifference();
        result = 31 * result + (this.getType() != null ? this.getType().ordinal() : 0);
        result = 31 * result + (this.propertyName != null ? this.propertyName.hashCode() : 0);
        result = 31 * result + (this.propertyType != null ? this.propertyType.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "GetPropertyInstruction{type='" + (Object)((Object)this.getType()) + '\'' + ", className='" + this.className + '\'' + ", propertyName='" + this.propertyName + '\'' + ", propertyType='" + this.propertyType + '\'' + '}';
    }
}

