/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.results;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.HttpMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameters;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import java.util.HashSet;
import java.util.Set;

public class MethodResult {
    private final Set<String> requestMediaTypes = new HashSet<String>();
    private final Set<String> responseMediaTypes = new HashSet<String>();
    private final MethodParameters methodParameters = new MethodParameters();
    private final Set<HttpResponse> responses = new HashSet<HttpResponse>();
    private String path;
    private String requestBodyType;
    private HttpMethod httpMethod;
    private ClassResult subResource;
    private ClassResult parentResource;

    public Set<String> getRequestMediaTypes() {
        return this.requestMediaTypes;
    }

    public Set<String> getResponseMediaTypes() {
        return this.responseMediaTypes;
    }

    public MethodParameters getMethodParameters() {
        return this.methodParameters;
    }

    public Set<HttpResponse> getResponses() {
        return this.responses;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getRequestBodyType() {
        return this.requestBodyType;
    }

    public void setRequestBodyType(String requestBodyType) {
        this.requestBodyType = requestBodyType;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public ClassResult getSubResource() {
        return this.subResource;
    }

    public void setSubResource(ClassResult subResource) {
        this.subResource = subResource;
        subResource.setParentSubResourceLocator(this);
    }

    public ClassResult getParentResource() {
        return this.parentResource;
    }

    public void setParentResource(ClassResult parentResource) {
        this.parentResource = parentResource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodResult that = (MethodResult)o;
        if (!this.requestMediaTypes.equals(that.requestMediaTypes)) {
            return false;
        }
        if (!this.responseMediaTypes.equals(that.responseMediaTypes)) {
            return false;
        }
        if (!this.methodParameters.equals(that.methodParameters)) {
            return false;
        }
        if (!this.responses.equals(that.responses)) {
            return false;
        }
        if (this.path != null ? !this.path.equals(that.path) : that.path != null) {
            return false;
        }
        if (this.requestBodyType != null ? !this.requestBodyType.equals(that.requestBodyType) : that.requestBodyType != null) {
            return false;
        }
        if (this.httpMethod != that.httpMethod) {
            return false;
        }
        return !(this.subResource != null ? !this.subResource.equals(that.subResource) : that.subResource != null);
    }

    public int hashCode() {
        int result = this.requestMediaTypes.hashCode();
        result = 31 * result + this.responseMediaTypes.hashCode();
        result = 31 * result + this.methodParameters.hashCode();
        result = 31 * result + this.responses.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        result = 31 * result + (this.requestBodyType != null ? this.requestBodyType.hashCode() : 0);
        result = 31 * result + (this.httpMethod != null ? this.httpMethod.hashCode() : 0);
        result = 31 * result + (this.subResource != null ? this.subResource.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "MethodResult{requestMediaTypes=" + this.requestMediaTypes + ", responseMediaTypes=" + this.responseMediaTypes + ", methodParameters=" + this.methodParameters + ", responses=" + this.responses + ", path='" + this.path + '\'' + ", requestBodyType='" + this.requestBodyType + '\'' + ", httpMethod=" + (Object)((Object)this.httpMethod) + ", subResource=" + this.subResource + ", parentResource=" + (this.parentResource == null ? "null" : "notNull") + '}';
    }
}

