/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Consumer;

public final class LogProvider {
    private static Consumer<String> infoLogger = System.err::println;
    private static Consumer<String> debugLogger = s -> {};
    private static Consumer<String> errorLogger = System.err::println;

    private LogProvider() {
        throw new UnsupportedOperationException();
    }

    public static void injectInfoLogger(Consumer<String> logger) {
        infoLogger = logger;
    }

    public static void injectDebugLogger(Consumer<String> logger) {
        debugLogger = logger;
    }

    public static void injectErrorLogger(Consumer<String> logger) {
        errorLogger = logger;
    }

    public static void info(String message) {
        infoLogger.accept(message);
    }

    public static void debug(String message) {
        debugLogger.accept(message);
    }

    public static void debug(Throwable throwable) {
        StringWriter errors = new StringWriter();
        throwable.printStackTrace(new PrintWriter(errors));
        debugLogger.accept(errors.toString());
    }

    public static void error(String message) {
        errorLogger.accept(message);
    }
}

