/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.JAXRSAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.BackendType;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Main {
    public static void main(String ... args) {
        if (args.length < 1) {
            Main.printUsageAndExit();
        }
        HashSet<Path> projectPaths = new HashSet<Path>();
        HashSet<Path> classPaths = new HashSet<Path>();
        BackendType backendType = null;
        String name = null;
        String version = null;
        String domain = null;
        Path outputFileLocation = null;
        try {
            block20: for (int i = 0; i < args.length; ++i) {
                if (args[i].startsWith("-")) {
                    switch (args[i]) {
                        case "-b": {
                            backendType = BackendType.getByNameIgnoreCase(args[++i]);
                            if (backendType != null) continue block20;
                            System.err.println("Unknown backend " + args[i] + '\n');
                            Main.printUsageAndExit();
                            break;
                        }
                        case "-cp": {
                            List<Path> paths = Stream.of(args[++i].split(":")).map(s -> s.replaceFirst("^~", System.getProperty("user.home"))).map(x$0 -> Paths.get(x$0, new String[0])).collect(Collectors.toList());
                            paths.forEach(p -> {
                                if (!p.toFile().exists()) {
                                    System.err.println("Class path " + p.toFile() + " doesn't exist\n");
                                    Main.printUsageAndExit();
                                }
                            });
                            paths.forEach(classPaths::add);
                            break;
                        }
                        case "-X": {
                            LogProvider.injectDebugLogger(System.err::println);
                            break;
                        }
                        case "-n": {
                            name = args[++i];
                            break;
                        }
                        case "-v": {
                            version = args[++i];
                            break;
                        }
                        case "-d": {
                            domain = args[++i];
                            break;
                        }
                        case "-o": {
                            outputFileLocation = Paths.get(args[++i], new String[0]);
                            break;
                        }
                        default: {
                            System.err.print("Unknown option " + args[i] + '\n');
                            Main.printUsageAndExit();
                            break;
                        }
                    }
                    continue;
                }
                Path path = Paths.get(args[i].replaceFirst("^~", System.getProperty("user.home")), new String[0]);
                if (!path.toFile().exists()) {
                    System.err.println("Location " + path.toFile() + " doesn't exist\n");
                    Main.printUsageAndExit();
                }
                projectPaths.add(path);
            }
        }
        catch (IndexOutOfBoundsException e) {
            System.err.println("Please provide valid number of arguments\n");
            Main.printUsageAndExit();
        }
        if (projectPaths.isEmpty()) {
            System.err.println("Please provide at least one project path\n");
            Main.printUsageAndExit();
        }
        JAXRSAnalyzer jaxrsAnalyzer = new JAXRSAnalyzer(projectPaths, classPaths, backendType, name, version, domain, outputFileLocation);
        jaxrsAnalyzer.analyze();
    }

    private static void printUsageAndExit() {
        System.err.println("Usage: java -jar jaxrs-analyzer.jar [options] classPath [classPaths...]");
        System.err.println("The classPath entries may be directories or jar-files containing the classes to be analyzed\n");
        System.err.println("Following available options:\n");
        System.err.println(" -b <backend> The backend to choose: swagger (default), plaintext, asciidoc");
        System.err.println(" -cp <class path>[:class paths] Additional class paths (separated with colon) which contain classes used in the project (may be directories or jar-files)");
        System.err.println(" -X Debug enabled (enabled error debugging information)");
        System.err.println(" -n <project name> The name of the project");
        System.err.println(" -v <project version> The version of the project");
        System.err.println(" -d <project domain> The domain of the project");
        System.err.println(" -o <output file> The location of the analysis output (will be printed to standard out if omitted)");
        System.err.println("\nExample: java -jar jaxrs-analyzer.jar -b swagger -n \"My Project\" -cp ~/libs/lib1.jar:~/libs/project/bin ~/project/target/classes");
        System.exit(1);
    }
}

