/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection.LoadStoreInstructionBuilder;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.DefaultInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.Mnemonic;
import javassist.bytecode.Opcode;

class WideInstructionBuilder
implements Opcode {
    private final CodeIterator codeIterator;
    private final LoadStoreInstructionBuilder loadStoreInstructionBuilder;

    WideInstructionBuilder(CodeIterator codeIterator, LoadStoreInstructionBuilder loadStoreInstructionBuilder) {
        this.codeIterator = codeIterator;
        this.loadStoreInstructionBuilder = loadStoreInstructionBuilder;
    }

    Instruction build(int position) {
        if (this.codeIterator.byteAt(position) != 196) {
            throw new IllegalArgumentException("WIDE instruction is not valid.");
        }
        int containedOpcode = this.codeIterator.byteAt(position + 1);
        switch (containedOpcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return this.loadStoreInstructionBuilder.buildLoad(this.codeIterator.u16bitAt(position + 2));
            }
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: {
                return this.loadStoreInstructionBuilder.buildStore(this.codeIterator.u16bitAt(position + 2));
            }
            case 132: 
            case 169: {
                return new DefaultInstruction(Mnemonic.OPCODE[containedOpcode]);
            }
        }
        throw new IllegalArgumentException("WIDE instruction is not valid.");
    }
}

