/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javassist.CtMethod;

class ResourceMethodContentAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final MethodSimulator methodSimulator = new MethodSimulator();

    ResourceMethodContentAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(CtMethod method, MethodResult result) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(method);
            List<Instruction> visitedInstructions = this.interpretRelevantInstructions(method);
            Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
            projectMethods.stream().forEach(MethodPool.getInstance()::addProjectMethod);
            Element returnedElement = this.methodSimulator.simulate(visitedInstructions);
            Type returnType = JavaUtils.getReturnType(method);
            if (returnType == null || Types.PRIMITIVE_VOID.equals(returnType)) {
                return;
            }
            if (returnedElement == null) {
                LogProvider.debug("Non-void method, but no return element returned after analysis");
                return;
            }
            Set possibleObjects = returnedElement.getPossibleValues().stream().filter(o -> !(o instanceof HttpResponse)).collect(Collectors.toSet());
            if (!Types.RESPONSE.equals(returnType)) {
                HttpResponse defaultResponse = new HttpResponse();
                if (Types.OBJECT.equals(returnType)) {
                    defaultResponse.getEntityTypes().addAll(returnedElement.getTypes());
                } else {
                    defaultResponse.getEntityTypes().add(returnType);
                }
                possibleObjects.stream().filter(o -> o instanceof JsonValue).map(o -> (JsonValue)o).forEach(defaultResponse.getInlineEntities()::add);
                result.getResponses().add(defaultResponse);
            }
            returnedElement.getPossibleValues().stream().filter(o -> o instanceof HttpResponse).map(o -> (HttpResponse)o).forEach(result.getResponses()::add);
        }
        finally {
            this.lock.unlock();
        }
    }
}

