/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodPool;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.MethodSimulator;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.classes.ClassAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;

class SubResourceLocatorMethodContentAnalyzer
extends MethodContentAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final ClassAnalyzer classAnalyzer = new ClassAnalyzer();
    private final MethodSimulator simulator = new MethodSimulator();

    SubResourceLocatorMethodContentAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void analyze(CtMethod method, ClassResult classResult) {
        this.lock.lock();
        try {
            this.buildPackagePrefix(method);
            this.determineReturnTypes(method).stream().map(Type::getCtClass).forEach(c -> this.classAnalyzer.analyzeSubResource((CtClass)c, classResult));
        }
        catch (Exception e) {
            LogProvider.error("Could not analyze sub-resource class ");
            LogProvider.debug(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private Set<Type> determineReturnTypes(CtMethod method) throws NotFoundException {
        List<Instruction> visitedInstructions = this.interpretRelevantInstructions(method);
        Set<ProjectMethod> projectMethods = this.findProjectMethods(visitedInstructions);
        projectMethods.stream().forEach(MethodPool.getInstance()::addProjectMethod);
        return this.simulator.simulate(visitedInstructions).getTypes();
    }
}

