/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.utils;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMember;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;

public final class JavaUtils {
    public static final String INITIALIZER_NAME = "<init>";
    public static final String BOOTSTRAP_ATTRIBUTE_NAME = "BootstrapMethods";

    private JavaUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isInitializerName(String name) {
        return INITIALIZER_NAME.equals(name);
    }

    public static Type determineMostSpecificType(Type ... types) {
        switch (types.length) {
            case 0: {
                throw new IllegalArgumentException("At lease one type has to be provided");
            }
            case 1: {
                return types[0];
            }
            case 2: {
                return JavaUtils.determineMostSpecific(types[0], types[1]);
            }
        }
        Type currentMostSpecific = JavaUtils.determineMostSpecific(types[0], types[1]);
        for (int i = 2; i < types.length; ++i) {
            currentMostSpecific = JavaUtils.determineMostSpecific(currentMostSpecific, types[i]);
        }
        return currentMostSpecific;
    }

    private static Type determineMostSpecific(Type firstType, Type secondType) {
        boolean secondTypeParameterized;
        if (Types.OBJECT.equals(secondType) || firstType.equals(secondType)) {
            return firstType;
        }
        if (Types.OBJECT.equals(firstType)) {
            return secondType;
        }
        boolean firstTypeParameterized = !firstType.getTypeParameters().isEmpty();
        boolean bl = secondTypeParameterized = !secondType.getTypeParameters().isEmpty();
        if (firstTypeParameterized || secondTypeParameterized) {
            if (firstTypeParameterized && !secondTypeParameterized) {
                return firstType;
            }
            if (!firstTypeParameterized) {
                return secondType;
            }
            if (firstType.getTypeParameters().size() != secondType.getTypeParameters().size()) {
                return firstType;
            }
            for (int i = 0; i < firstType.getTypeParameters().size(); ++i) {
                Type secondInner;
                Type firstInner = firstType.getTypeParameters().get(i);
                if (firstInner.equals(secondInner = secondType.getTypeParameters().get(i))) continue;
                if (firstInner == JavaUtils.determineMostSpecific(firstInner, secondInner)) {
                    return firstType;
                }
                return secondType;
            }
        }
        if (firstType.isAssignableTo(secondType)) {
            return firstType;
        }
        if (secondType.isAssignableTo(firstType)) {
            return secondType;
        }
        boolean firstTypeArray = firstType.toString().contains("[");
        boolean secondTypeArray = secondType.toString().contains("[");
        if (firstTypeArray || secondTypeArray) {
            if (firstTypeArray && !secondTypeArray) {
                return firstType;
            }
            if (!firstTypeArray) {
                return secondType;
            }
        }
        return firstType;
    }

    public static CtBehavior getMethod(MethodIdentifier identifier) {
        CtClass ctClass = identifier.getContainingClass().getCtClass();
        if (JavaUtils.isInitializerName(identifier.getMethodName())) {
            return Stream.of(ctClass.getDeclaredConstructors()).filter(b -> identifier.getParameters().equals(JavaUtils.getRawParameterTypes(b))).findAny().orElse(null);
        }
        return Stream.concat(Stream.of(ctClass.getDeclaredMethods()), Stream.of(ctClass.getMethods())).filter(b -> identifier.getMethodName().equals(b.getName())).filter(b -> identifier.getParameters().equals(JavaUtils.getRawParameterTypes(b))).findAny().orElse(null);
    }

    private static List<Type> getRawParameterTypes(CtBehavior behavior) {
        try {
            return Stream.of(SignatureAttribute.toMethodSignature(behavior.getSignature()).getParameterTypes()).map(Type::new).collect(Collectors.toList());
        }
        catch (BadBytecode e) {
            return Collections.emptyList();
        }
    }

    public static List<Type> getParameterTypes(CtBehavior behavior) {
        try {
            String sig = behavior.getGenericSignature() == null ? behavior.getSignature() : behavior.getGenericSignature();
            return Stream.of(SignatureAttribute.toMethodSignature(sig).getParameterTypes()).map(Type::new).collect(Collectors.toList());
        }
        catch (BadBytecode e) {
            return Collections.emptyList();
        }
    }

    public static Type getFieldType(CtField field) {
        try {
            String sig = field.getGenericSignature() == null ? field.getSignature() : field.getGenericSignature();
            return new Type(SignatureAttribute.toTypeSignature(sig));
        }
        catch (BadBytecode e) {
            LogProvider.error("Could not analyze field: " + field);
            LogProvider.debug(e);
            return null;
        }
    }

    public static Type getReturnType(CtBehavior behavior) {
        try {
            String sig = behavior.getGenericSignature() == null ? behavior.getSignature() : behavior.getGenericSignature();
            return new Type(SignatureAttribute.toMethodSignature(sig).getReturnType());
        }
        catch (BadBytecode e) {
            LogProvider.error("Could not analyze method: " + behavior);
            LogProvider.debug(e);
            return null;
        }
    }

    public static boolean isSynthetic(CtMember member) {
        return (member.getModifiers() & 0x1000) != 0;
    }
}

