/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.utils;

public class Pair<T, U> {
    private final T left;
    private final U right;

    private Pair(T left, U right) {
        this.left = left;
        this.right = right;
    }

    public T getLeft() {
        return this.left;
    }

    public U getRight() {
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pair pair = (Pair)o;
        if (this.left != null ? !this.left.equals(pair.left) : pair.left != null) {
            return false;
        }
        return !(this.right == null ? pair.right != null : !this.right.equals(pair.right));
    }

    public int hashCode() {
        int result = this.left != null ? this.left.hashCode() : 0;
        result = 31 * result + (this.right != null ? this.right.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Pair{left=" + this.left + ", right=" + this.right + '}';
    }

    public static <V, W> Pair<V, W> of(V left, W right) {
        return new Pair<V, W>(left, right);
    }
}

