/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.elements;

import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class Element {
    public static final Element EMPTY = new UnmodifiableElement(Types.OBJECT);
    private final Set<Object> possibleValues;
    private final Set<Type> types;

    public Element(Type type, Object ... values) {
        this(Collections.singleton(type), values);
    }

    public Element(Set<Type> types, Object ... values) {
        Objects.requireNonNull(types);
        this.types = new HashSet<Type>(types);
        this.possibleValues = new HashSet<Object>();
        if (values == null) {
            this.possibleValues.add(null);
        } else {
            Collections.addAll(this.possibleValues, values);
        }
    }

    public Element merge(Element element) {
        this.types.addAll(element.types);
        this.possibleValues.addAll(element.possibleValues);
        return this;
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues;
    }

    public Set<Type> getTypes() {
        return this.types;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Element element = (Element)o;
        if (!this.possibleValues.equals(element.possibleValues)) {
            return false;
        }
        return this.types.equals(element.types);
    }

    public int hashCode() {
        int result = this.possibleValues.hashCode();
        result = 31 * result + this.types.hashCode();
        return result;
    }

    public String toString() {
        return "Element{possibleValues=" + this.possibleValues + ", types='" + this.types + '\'' + '}';
    }

    private static class UnmodifiableElement
    extends Element {
        public UnmodifiableElement(Type type) {
            super(type, new Object[0]);
        }

        @Override
        public Set<Object> getPossibleValues() {
            return Collections.unmodifiableSet(super.getPossibleValues());
        }

        @Override
        public Set<Type> getTypes() {
            return Collections.unmodifiableSet(super.getTypes());
        }
    }
}

