/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.InvokeInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import java.util.Objects;

public class InvokeDynamicInstruction
extends InvokeInstruction {
    private final MethodIdentifier dynamicIdentifier;

    public InvokeDynamicInstruction(MethodIdentifier methodHandleIdentifier, MethodIdentifier dynamicIdentifier) {
        super(methodHandleIdentifier);
        Objects.requireNonNull(dynamicIdentifier);
        this.dynamicIdentifier = dynamicIdentifier;
    }

    @Override
    public int getStackSizeDifference() {
        int difference = 1;
        for (Type parameterType : this.dynamicIdentifier.getParameters()) {
            --difference;
        }
        return difference;
    }

    public MethodIdentifier getDynamicIdentifier() {
        return this.dynamicIdentifier;
    }

    @Override
    public Instruction.InstructionType getType() {
        return Instruction.InstructionType.METHOD_HANDLE;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InvokeDynamicInstruction that = (InvokeDynamicInstruction)o;
        return this.dynamicIdentifier.equals(that.dynamicIdentifier);
    }

    @Override
    public int hashCode() {
        return this.dynamicIdentifier.hashCode();
    }

    @Override
    public String toString() {
        return "InvokeDynamicInstruction{dynamicIdentifier='" + this.dynamicIdentifier + '\'' + ", identifier='" + this.getIdentifier() + '\'' + '}';
    }
}

