/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.rest;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.HttpMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameters;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ResourceMethod {
    private final Set<String> requestMediaTypes = new HashSet<String>();
    private final Set<String> responseMediaTypes = new HashSet<String>();
    private final Map<Integer, Response> responses = new HashMap<Integer, Response>();
    private final MethodParameters methodParameters;
    private final HttpMethod method;
    private TypeRepresentation requestBody;

    public ResourceMethod(HttpMethod method) {
        this(method, new MethodParameters());
    }

    public ResourceMethod(HttpMethod method, MethodParameters methodParameters) {
        Objects.requireNonNull(method);
        Objects.requireNonNull(methodParameters);
        this.method = method;
        this.methodParameters = methodParameters;
    }

    public Set<String> getRequestMediaTypes() {
        return this.requestMediaTypes;
    }

    public Set<String> getResponseMediaTypes() {
        return this.responseMediaTypes;
    }

    public Map<Integer, Response> getResponses() {
        return this.responses;
    }

    public MethodParameters getMethodParameters() {
        return this.methodParameters;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public TypeRepresentation getRequestBody() {
        return this.requestBody;
    }

    public void setRequestBody(TypeRepresentation requestBody) {
        this.requestBody = requestBody;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceMethod that = (ResourceMethod)o;
        if (!this.requestMediaTypes.equals(that.requestMediaTypes)) {
            return false;
        }
        if (!this.responseMediaTypes.equals(that.responseMediaTypes)) {
            return false;
        }
        if (!this.responses.equals(that.responses)) {
            return false;
        }
        if (!this.methodParameters.equals(that.methodParameters)) {
            return false;
        }
        if (this.method != that.method) {
            return false;
        }
        return !(this.requestBody == null ? that.requestBody != null : !this.requestBody.equals(that.requestBody));
    }

    public int hashCode() {
        int result = this.requestMediaTypes.hashCode();
        result = 31 * result + this.responseMediaTypes.hashCode();
        result = 31 * result + this.responses.hashCode();
        result = 31 * result + this.methodParameters.hashCode();
        result = 31 * result + this.method.hashCode();
        result = 31 * result + (this.requestBody != null ? this.requestBody.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "ResourceMethod{requestMediaTypes=" + this.requestMediaTypes + ", responseMediaTypes=" + this.responseMediaTypes + ", responses=" + this.responses + ", methodParameters=" + this.methodParameters + ", method=" + (Object)((Object)this.method) + ", requestBody=" + this.requestBody + '}';
    }
}

