/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.results;

import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ClassResult {
    private String applicationPath;
    private String resourcePath;
    private final Set<MethodResult> methods = new HashSet<MethodResult>();
    private final Set<String> requestMediaTypes = new HashSet<String>();
    private final Set<String> responseMediaTypes = new HashSet<String>();
    private MethodResult parentSubResourceLocator;

    public String getApplicationPath() {
        return this.applicationPath;
    }

    public void setApplicationPath(String applicationPath) {
        this.applicationPath = applicationPath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public Set<MethodResult> getMethods() {
        return Collections.unmodifiableSet(this.methods);
    }

    public void add(MethodResult methodResult) {
        this.methods.add(methodResult);
        methodResult.setParentResource(this);
    }

    public Set<String> getRequestMediaTypes() {
        return this.requestMediaTypes;
    }

    public Set<String> getResponseMediaTypes() {
        return this.responseMediaTypes;
    }

    public MethodResult getParentSubResourceLocator() {
        return this.parentSubResourceLocator;
    }

    public void setParentSubResourceLocator(MethodResult parentSubResourceLocator) {
        this.parentSubResourceLocator = parentSubResourceLocator;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClassResult that = (ClassResult)o;
        if (!this.requestMediaTypes.equals(that.requestMediaTypes)) {
            return false;
        }
        if (this.applicationPath != null ? !this.applicationPath.equals(that.applicationPath) : that.applicationPath != null) {
            return false;
        }
        if (!this.methods.equals(that.methods)) {
            return false;
        }
        if (this.resourcePath != null ? !this.resourcePath.equals(that.resourcePath) : that.resourcePath != null) {
            return false;
        }
        return this.responseMediaTypes.equals(that.responseMediaTypes);
    }

    public int hashCode() {
        int result = this.applicationPath != null ? this.applicationPath.hashCode() : 0;
        result = 31 * result + (this.resourcePath != null ? this.resourcePath.hashCode() : 0);
        result = 31 * result + this.methods.hashCode();
        result = 31 * result + this.requestMediaTypes.hashCode();
        result = 31 * result + this.responseMediaTypes.hashCode();
        return result;
    }

    public String toString() {
        return "ClassResult{applicationPath='" + this.applicationPath + '\'' + ", resourcePath='" + this.resourcePath + '\'' + ", methods=" + this.methods + ", requestMediaTypes=" + this.requestMediaTypes + ", responseMediaTypes=" + this.responseMediaTypes + ", parentSubResourceLocator=" + (this.parentSubResourceLocator == null ? "null" : "notNull") + '}';
    }
}

