/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.types;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.model.types.TypeExtractor;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;

public class Type {
    private final CtClass ctClass;
    private final List<Type> typeParameters;

    public Type(String type) {
        try {
            this.ctClass = TypeExtractor.toErasuredClass(type);
            this.typeParameters = TypeExtractor.toTypeParameters(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Type(CtClass ctClass) {
        try {
            this.ctClass = TypeExtractor.toErasuredClass(ctClass.getName());
            this.typeParameters = Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Type(SignatureAttribute.Type sigType) {
        String type = Type.getType(sigType);
        try {
            this.ctClass = TypeExtractor.toErasuredClass(type);
            this.typeParameters = TypeExtractor.toTypeParameters(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getType(SignatureAttribute.Type type) {
        if (type instanceof SignatureAttribute.ClassType) {
            StringBuilder builder = new StringBuilder();
            if (type instanceof SignatureAttribute.NestedClassType) {
                SignatureAttribute.NestedClassType nestedClassType = (SignatureAttribute.NestedClassType)type;
                LinkedList<SignatureAttribute.ClassType> declaringClasses = new LinkedList<SignatureAttribute.ClassType>();
                for (SignatureAttribute.ClassType declaringClass = nestedClassType.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
                    declaringClasses.add(declaringClass);
                }
                Collections.reverse(declaringClasses);
                declaringClasses.forEach(c -> builder.append(c.getName()).append('$'));
                builder.append(nestedClassType.getName());
            } else {
                builder.append(((SignatureAttribute.ClassType)type).getName());
            }
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)type;
            if (classType.getTypeArguments() != null) {
                builder.append('<');
                for (int i = 0; i < classType.getTypeArguments().length; ++i) {
                    builder.append(Type.getTypeArgument(classType.getTypeArguments()[i]));
                    if (i >= classType.getTypeArguments().length - 1) continue;
                    builder.append(',');
                }
                builder.append('>');
            }
            return builder.toString();
        }
        if (type instanceof SignatureAttribute.ArrayType) {
            SignatureAttribute.ArrayType arrayType = (SignatureAttribute.ArrayType)type;
            StringBuilder builder = new StringBuilder(Type.getType(arrayType.getComponentType()));
            for (int i = 0; i < arrayType.getDimension(); ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }
        return type.toString();
    }

    private static String getTypeArgument(SignatureAttribute.TypeArgument typeArgument) {
        if (typeArgument.getKind() == '*') {
            return Types.OBJECT.toString();
        }
        return Type.getType(typeArgument.getType());
    }

    public CtClass getCtClass() {
        return this.ctClass;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isAssignableTo(Type type) {
        if (this.equals(type)) {
            return true;
        }
        if (this.ctClass.equals(type.ctClass) && (this.typeParameters.isEmpty() || type.typeParameters.isEmpty())) {
            return true;
        }
        try {
            CtClass superclass = this.ctClass.getSuperclass();
            if (superclass != null && !Types.OBJECT.ctClass.equals(superclass) && new Type(superclass).isAssignableTo(type)) {
                return true;
            }
            return Stream.of(this.ctClass.getInterfaces()).anyMatch(i -> new Type((CtClass)i).isAssignableTo(type));
        }
        catch (NotFoundException e) {
            LogProvider.error("Could not analyze superclass of: " + this.ctClass.getName() + ", reason: " + e.getMessage());
            LogProvider.debug(e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)o;
        if (!this.ctClass.equals(type.ctClass)) {
            return false;
        }
        return this.typeParameters.equals(type.typeParameters);
    }

    public int hashCode() {
        int result = this.ctClass.hashCode();
        result = 31 * result + this.typeParameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.ctClass.getName());
        int lastIndexOf = builder.indexOf("[]");
        CharSequence suffix = null;
        if (lastIndexOf >= 0) {
            suffix = builder.subSequence(lastIndexOf, builder.length());
            builder.delete(lastIndexOf, builder.length());
        }
        if (!this.typeParameters.isEmpty()) {
            builder.append('<');
            builder.append(this.typeParameters.stream().map(Object::toString).collect(Collectors.joining(", ")));
            builder.append('>');
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }
}

