/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.BackendType;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class JAXRSAnalyzer {
    private static final String DEFAULT_NAME = "project";
    private static final String DEFAULT_VERSION = "0.1-SNAPSHOT";
    private static final String DEFAULT_DOMAIN = "example.com";
    private static final BackendType DEFAULT_BACKEND = BackendType.SWAGGER;
    private final Set<Path> projectPaths = new HashSet<Path>();
    private final Set<Path> classPaths = new HashSet<Path>();
    private final BackendType backendType;
    private final String projectName;
    private final String projectVersion;
    private final String domain;
    private final Path outputLocation;

    public JAXRSAnalyzer(Set<Path> projectPaths, Set<Path> classPaths, BackendType backendType, String projectName, String projectVersion, String domain, Path outputLocation) {
        Objects.requireNonNull(projectPaths);
        Objects.requireNonNull(classPaths);
        if (projectPaths.isEmpty()) {
            throw new IllegalArgumentException("At least one project path is mandatory");
        }
        this.projectPaths.addAll(projectPaths);
        this.classPaths.addAll(classPaths);
        this.projectName = Optional.ofNullable(projectName).orElse(DEFAULT_NAME);
        this.projectVersion = Optional.ofNullable(projectVersion).orElse(DEFAULT_VERSION);
        this.domain = Optional.ofNullable(domain).orElse(DEFAULT_DOMAIN);
        this.backendType = Optional.ofNullable(backendType).orElse(DEFAULT_BACKEND);
        this.outputLocation = outputLocation;
    }

    public void analyze() {
        Resources resources = new ProjectAnalyzer(this.classPaths.toArray(new Path[this.classPaths.size()])).analyze(this.projectPaths.toArray(new Path[this.projectPaths.size()]));
        Project project = new Project(this.projectName, this.projectVersion, this.domain, resources);
        if (this.isEmpty(resources)) {
            LogProvider.info("Empty JAX-RS analysis result, omitting output");
            return;
        }
        String output = this.backendType.getBackendSupplier().get().render(project);
        if (this.outputLocation != null) {
            JAXRSAnalyzer.outputToFile(output, this.outputLocation);
        } else {
            System.out.println(output);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEmpty(Resources resources) {
        if (resources.getResources().isEmpty()) return true;
        if (!resources.getResources().stream().map(resources::getMethods).noneMatch(s -> !s.isEmpty())) return false;
        return true;
    }

    private static void outputToFile(String output, Path outputLocation) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(outputLocation.toFile()));){
            writer.write(output);
            ((Writer)writer).flush();
        }
        catch (IOException e) {
            LogProvider.error("Could not write to the specified output location, reason: " + e.getMessage());
            LogProvider.debug(e);
        }
    }
}

