/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.classes.ClassAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.ResultInterpreter;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;

public class ProjectAnalyzer {
    private final Lock lock = new ReentrantLock();
    private final Set<CtClass> classes = new HashSet<CtClass>();
    private final ClassAnalyzer classAnalyzer = new ClassAnalyzer();
    private final ResultInterpreter resultInterpreter = new ResultInterpreter();

    public ProjectAnalyzer(Path ... classPaths) {
        Stream.of(classPaths).forEach(this::addToClassPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resources analyze(Path ... projectPaths) {
        this.lock.lock();
        try {
            Stream.of(projectPaths).forEach(this::addProjectPath);
            Set<ClassResult> classResults = this.classes.stream().map(this.classAnalyzer::analyze).filter(Objects::nonNull).collect(Collectors.toSet());
            Resources resources = this.resultInterpreter.interpret(classResults);
            return resources;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void addToClassPool(Path location) {
        if (!location.toFile().exists()) {
            throw new IllegalArgumentException("The location '" + location + "' does not exist!");
        }
        try {
            ClassPool.getDefault().insertClassPath(location.toString());
        }
        catch (NotFoundException e) {
            throw new IllegalArgumentException("The location '" + location + "' could not be loaded!", e);
        }
    }

    private void addProjectPath(Path path) {
        this.addToClassPool(path);
        if (path.toFile().isFile() && path.toString().endsWith(".jar")) {
            this.addJarClasses(path);
        } else if (path.toFile().isDirectory()) {
            this.addDirectoryClasses(path, Paths.get("", new String[0]));
        } else {
            throw new IllegalArgumentException("The project path '" + path + "' must be a jar file or a directory");
        }
    }

    private void addJarClasses(Path location) {
        try (JarFile jarFile = new JarFile(location.toFile());){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String entryName = entries.nextElement().getName();
                if (!entryName.endsWith(".class")) continue;
                try {
                    this.classes.add(ClassPool.getDefault().getCtClass(ProjectAnalyzer.convertToQualifiedName(entryName)));
                }
                catch (NotFoundException e) {
                    LogProvider.error("Could not load class file " + entryName);
                    LogProvider.debug(e);
                }
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not read jar-file '" + location + "', reason: " + e.getMessage());
        }
    }

    private void addDirectoryClasses(Path location, Path subPath) {
        for (File file : location.toFile().listFiles()) {
            if (file.isDirectory()) {
                this.addDirectoryClasses(location.resolve(file.getName()), subPath.resolve(file.getName()));
                continue;
            }
            if (!file.isFile() || !file.getName().endsWith(".class")) continue;
            String classFileName = subPath.resolve(file.getName()).toString();
            try {
                this.classes.add(ClassPool.getDefault().getCtClass(ProjectAnalyzer.convertToQualifiedName(classFileName)));
            }
            catch (NotFoundException e) {
                LogProvider.error("Could not load class file " + classFileName);
                LogProvider.debug(e);
            }
        }
    }

    private static String convertToQualifiedName(String fileName) {
        String replacedSeparators = fileName.replace(File.separatorChar, '.');
        return replacedSeparators.substring(0, replacedSeparators.length() - ".class".length());
    }
}

