/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.collection;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.LoadInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.StoreInstruction;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.IntStream;
import javassist.CtBehavior;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeAttribute;
import javassist.bytecode.LocalVariableAttribute;
import javassist.bytecode.LocalVariableTypeAttribute;
import javassist.bytecode.SignatureAttribute;

class LoadStoreInstructionBuilder {
    private static final String UNKNOWN_VARIABLE_NAME_PREFIX = "variable$";
    private final Map<Integer, String> variableNames;
    private final Map<Integer, Type> variableTypes;

    LoadStoreInstructionBuilder(CodeAttribute codeAttribute, CtBehavior method) {
        LocalVariableAttribute localVariableAttribute = (LocalVariableAttribute)codeAttribute.getAttribute("LocalVariableTable");
        LocalVariableTypeAttribute localVariableTypeAttribute = (LocalVariableTypeAttribute)codeAttribute.getAttribute("LocalVariableTypeTable");
        this.variableNames = this.buildVariableNames(localVariableAttribute);
        this.variableTypes = this.buildVariableTypes(localVariableAttribute, localVariableTypeAttribute, method);
    }

    private Map<Integer, String> buildVariableNames(LocalVariableAttribute variableAttribute) {
        if (variableAttribute == null) {
            return Collections.emptyMap();
        }
        return IntStream.range(0, variableAttribute.tableLength()).collect(HashMap::new, (m, i) -> m.put(variableAttribute.index(i), variableAttribute.variableName(i)), Map::putAll);
    }

    private Map<Integer, Type> buildVariableTypes(LocalVariableAttribute variableAttribute, LocalVariableTypeAttribute variableTypeAttribute, CtBehavior method) {
        HashMap<Integer, Type> types = new HashMap<Integer, Type>();
        if (variableAttribute != null) {
            IntStream.range(0, variableAttribute.tableLength()).forEach(i -> types.put(variableAttribute.index(i), this.getType(variableAttribute.signature(i), method)));
        }
        if (variableTypeAttribute != null) {
            IntStream.range(0, variableTypeAttribute.tableLength()).forEach(i -> types.put(variableTypeAttribute.index(i), this.getType(variableTypeAttribute.signature(i), method)));
        }
        return types;
    }

    private Type getType(String signature, CtBehavior method) {
        try {
            SignatureAttribute.ClassSignature genericClassSignature = method.getDeclaringClass().getGenericSignature() == null ? null : SignatureAttribute.toClassSignature(method.getDeclaringClass().getGenericSignature());
            SignatureAttribute.MethodSignature methodSig = method.getGenericSignature() == null ? null : SignatureAttribute.toMethodSignature(method.getGenericSignature());
            return new Type(SignatureAttribute.toTypeSignature(signature), genericClassSignature, null, methodSig);
        }
        catch (BadBytecode e) {
            LogProvider.error("Could not analyze type for signature: " + signature + ", reason: " + e.getMessage());
            LogProvider.debug(e);
            return null;
        }
    }

    LoadInstruction buildLoad(int index) {
        Type type = this.variableTypes.getOrDefault(index, Types.OBJECT);
        String name = this.variableNames.getOrDefault(index, UNKNOWN_VARIABLE_NAME_PREFIX + index);
        return new LoadInstruction(index, type, name);
    }

    StoreInstruction buildStore(int index) {
        Type type = this.variableTypes.getOrDefault(index, Types.OBJECT);
        String name = this.variableNames.getOrDefault(index, UNKNOWN_VARIABLE_NAME_PREFIX + index);
        return new StoreInstruction(index, type, name);
    }
}

