/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.List;
import java.util.function.BiFunction;

enum KnownJsonResultMethod implements IdentifiableMethod
{
    JSON_ARRAY_BUILDER_CREATE(MethodIdentifier.ofStatic(Types.JSON, "createArrayBuilder", Types.JSON_ARRAY_BUILDER, new Type[0]), (object, arguments) -> new Element(Types.JSON_ARRAY, new JsonArray())),
    JSON_ARRAY_BUILDER_ADD_BIG_DECIMAL(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.BIG_DECIMAL), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.BIG_DECIMAL)),
    JSON_ARRAY_BUILDER_ADD_BIG_INTEGER(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.BIG_INTEGER), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.BIG_INTEGER)),
    JSON_ARRAY_BUILDER_ADD_STRING(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.STRING), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.STRING)),
    JSON_ARRAY_BUILDER_ADD_INT(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.PRIMITIVE_INT), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.INTEGER)),
    JSON_ARRAY_BUILDER_ADD_LONG(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.PRIMITIVE_LONG), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.LONG)),
    JSON_ARRAY_BUILDER_ADD_DOUBLE(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.PRIMITIVE_DOUBLE), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.DOUBLE)),
    JSON_ARRAY_BUILDER_ADD_BOOLEAN(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.PRIMITIVE_BOOLEAN), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.PRIMITIVE_BOOLEAN)),
    JSON_ARRAY_BUILDER_ADD_JSON(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.JSON_VALUE), KnownJsonResultMethod::addToArray),
    JSON_ARRAY_BUILDER_ADD_JSON_OBJECT(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.JSON_OBJECT_BUILDER), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.JSON_OBJECT)),
    JSON_ARRAY_BUILDER_ADD_JSON_ARRAY(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "add", Types.JSON_ARRAY_BUILDER, Types.JSON_ARRAY_BUILDER), (object, arguments) -> KnownJsonResultMethod.addToArray(object, arguments, Types.JSON_ARRAY)),
    JSON_ARRAY_BUILDER_ADD_NULL(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "addNull", Types.JSON_ARRAY_BUILDER, new Type[0]), (object, arguments) -> {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonArray).map(o -> (JsonArray)o).forEach(a -> a.getElements().add(new Element(Types.OBJECT, null)));
        return object;
    }),
    JSON_ARRAY_BUILDER_BUILD(MethodIdentifier.ofNonStatic(Types.JSON_ARRAY_BUILDER, "build", Types.JSON_ARRAY, new Type[0]), (object, arguments) -> {
        Element json = new Element(Types.JSON_ARRAY, new Object[0]);
        json.getPossibleValues().addAll(object.getPossibleValues());
        return json;
    }),
    JSON_OBJECT_BUILDER_CREATE(MethodIdentifier.ofStatic(Types.JSON, "createObjectBuilder", Types.JSON_OBJECT_BUILDER, new Type[0]), (object, arguments) -> new Element(Types.JSON_OBJECT, new JsonObject())),
    JSON_OBJECT_BUILDER_ADD_BIG_DECIMAL(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.BIG_DECIMAL), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.BIG_DECIMAL)),
    JSON_OBJECT_BUILDER_ADD_BIG_INTEGER(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.BIG_INTEGER), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.BIG_INTEGER)),
    JSON_OBJECT_BUILDER_ADD_STRING(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.STRING), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.STRING)),
    JSON_OBJECT_BUILDER_ADD_INT(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.PRIMITIVE_INT), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.INTEGER)),
    JSON_OBJECT_BUILDER_ADD_LONG(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.PRIMITIVE_LONG), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.LONG)),
    JSON_OBJECT_BUILDER_ADD_DOUBLE(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.PRIMITIVE_DOUBLE), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.DOUBLE)),
    JSON_OBJECT_BUILDER_ADD_BOOLEAN(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.PRIMITIVE_BOOLEAN), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.PRIMITIVE_BOOLEAN)),
    JSON_OBJECT_BUILDER_ADD_JSON(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.JSON_VALUE), KnownJsonResultMethod::mergeJsonStructure),
    JSON_OBJECT_BUILDER_ADD_JSON_OBJECT(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.JSON_OBJECT_BUILDER), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.JSON_OBJECT)),
    JSON_OBJECT_BUILDER_ADD_JSON_ARRAY(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "add", Types.JSON_OBJECT_BUILDER, Types.STRING, Types.JSON_ARRAY_BUILDER), (object, arguments) -> KnownJsonResultMethod.mergeJsonStructure(object, arguments, Types.JSON_ARRAY)),
    JSON_OBJECT_BUILDER_ADD_NULL(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "addNull", Types.JSON_OBJECT_BUILDER, Types.STRING), (object, arguments) -> {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).forEach(o -> ((Element)arguments.get(0)).getPossibleValues().stream().map(s -> (String)s).forEach(s -> o.getStructure().merge((String)s, new Element(Types.OBJECT, null), Element::merge)));
        return object;
    }),
    JSON_OBJECT_BUILDER_BUILD(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT_BUILDER, "build", Types.JSON_OBJECT, new Type[0]), (object, arguments) -> {
        Element json = new Element(Types.JSON_OBJECT, new Object[0]);
        json.getPossibleValues().addAll(object.getPossibleValues());
        return json;
    }),
    JSON_OBJECT_GET_BOOLEAN(MethodIdentifier.ofNonStatic(Types.JSON_OBJECT, "getBoolean", Types.PRIMITIVE_BOOLEAN, Types.STRING), (object, arguments) -> object.getPossibleValues().stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).map(o -> ((Element)arguments.get(0)).getPossibleValues().stream().map(s -> (String)s).map(s -> o.getStructure().get(s)).reduce(new Element(Types.PRIMITIVE_BOOLEAN, new Object[0]), Element::merge)).reduce(new Element(Types.PRIMITIVE_BOOLEAN, new Object[0]), Element::merge));

    private final MethodIdentifier identifier;
    private final BiFunction<Element, List<Element>, Element> function;

    private KnownJsonResultMethod(MethodIdentifier identifier, BiFunction<Element, List<Element>, Element> function) {
        this.identifier = identifier;
        this.function = function;
    }

    @Override
    public Element invoke(Element object, List<Element> arguments) {
        if (arguments.size() != this.identifier.getParameters().size()) {
            throw new IllegalArgumentException("Method arguments do not match expected signature!");
        }
        return this.function.apply(object, arguments);
    }

    @Override
    public boolean matches(MethodIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    private static Element addToArray(Element object, List<Element> arguments) {
        return KnownJsonResultMethod.addToArray(object, arguments.get(0));
    }

    private static Element addToArray(Element object, List<Element> arguments, Type typeOverride) {
        Element element = new Element(typeOverride, new Object[0]);
        element.getPossibleValues().addAll(arguments.get(0).getPossibleValues());
        return KnownJsonResultMethod.addToArray(object, element);
    }

    private static Element addToArray(Element object, Element argument) {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonArray).map(o -> (JsonArray)o).forEach(a -> a.getElements().add(argument));
        return object;
    }

    private static Element mergeJsonStructure(Element object, List<Element> arguments) {
        Element element = new Element(arguments.get(1).getTypes(), new Object[0]);
        element.merge(arguments.get(1));
        return KnownJsonResultMethod.mergeJsonStructure(object, arguments.get(0), element);
    }

    private static Element mergeJsonStructure(Element object, List<Element> arguments, Type typeOverride) {
        Element element = new Element(typeOverride, new Object[0]);
        element.getPossibleValues().addAll(arguments.get(1).getPossibleValues());
        return KnownJsonResultMethod.mergeJsonStructure(object, arguments.get(0), element);
    }

    private static Element mergeJsonStructure(Element object, Element key, Element argument) {
        object.getPossibleValues().stream().filter(o -> o instanceof JsonObject).map(o -> (JsonObject)o).forEach(o -> key.getPossibleValues().stream().map(s -> (String)s).forEach(s -> o.getStructure().merge((String)s, argument, Element::merge)));
        return object;
    }
}

