/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.MethodHandle;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.ws.rs.core.CacheControl;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.Variant;

enum KnownResponseResultMethod implements IdentifiableMethod
{
    RESPONSE_BUILDER_BUILD(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "build", Types.RESPONSE, new Type[0]), (object, arguments) -> object),
    RESPONSE_BUILDER_CACHE_CONTROL(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "cacheControl", Types.RESPONSE_BUILDER, new Type(CacheControl.class.getName())), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Cache-Control")),
    RESPONSE_BUILDER_CONTENT_LOCATION(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "contentLocation", Types.RESPONSE_BUILDER, Types.URI), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Location")),
    RESPONSE_BUILDER_COOKIE(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "cookie", Types.RESPONSE_BUILDER, new Type(NewCookie[].class.getName())), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Set-Cookie")),
    RESPONSE_BUILDER_ENCODING(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "encoding", Types.RESPONSE_BUILDER, Types.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Encoding")),
    RESPONSE_BUILDER_ENTITY(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "entity", Types.RESPONSE_BUILDER, Types.OBJECT), (object, arguments) -> KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0))),
    RESPONSE_BUILDER_ENTITY_ANNOTATION(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "entity", Types.RESPONSE_BUILDER, Types.OBJECT, new Type(Annotation[].class.getName())), (object, arguments) -> KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0))),
    RESPONSE_BUILDER_EXPIRES(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "expires", Types.RESPONSE_BUILDER, Types.DATE), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Expires")),
    RESPONSE_BUILDER_HEADER(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "header", Types.RESPONSE_BUILDER, Types.STRING, Types.OBJECT), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(header -> (String)header).forEach(h -> KnownResponseResultMethod.addHeader(object, h));
        return object;
    }),
    RESPONSE_BUILDER_LANGUAGE_LOCALE(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "language", Types.RESPONSE_BUILDER, new Type(Locale.class.getName())), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Language")),
    RESPONSE_BUILDER_LANGUAGE_STRING(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "language", Types.RESPONSE_BUILDER, Types.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Content-Language")),
    RESPONSE_BUILDER_LAST_MODIFIED(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "lastModified", Types.RESPONSE_BUILDER, Types.DATE), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Last-Modified")),
    RESPONSE_BUILDER_LINK_URI(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "link", Types.RESPONSE_BUILDER, Types.URI, Types.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LINK_STRING(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "link", Types.RESPONSE_BUILDER, Types.STRING, Types.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LINKS(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "links", Types.RESPONSE_BUILDER, new Type(Link[].class.getName())), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Link")),
    RESPONSE_BUILDER_LOCATION(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "location", Types.RESPONSE_BUILDER, Types.URI), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Location")),
    RESPONSE_BUILDER_STATUS_ENUM(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "status", Types.RESPONSE_BUILDER, Types.RESPONSE_STATUS), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_BUILDER_STATUS_INT(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "status", Types.RESPONSE_BUILDER, Types.PRIMITIVE_INT), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_BUILDER_TAG_ENTITY(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "tag", Types.RESPONSE_BUILDER, Types.ENTITY_TAG), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "ETag")),
    RESPONSE_BUILDER_TAG_STRING(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "tag", Types.RESPONSE_BUILDER, Types.STRING), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "ETag")),
    RESPONSE_BUILDER_TYPE(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "type", Types.RESPONSE_BUILDER, new Type(MediaType.class.getName())), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(m -> (MediaType)m).map(m -> m.getType() + '/' + m.getSubtype()).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return object;
    }),
    RESPONSE_BUILDER_TYPE_STRING(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "type", Types.RESPONSE_BUILDER, Types.STRING), (object, arguments) -> {
        ((Element)arguments.get(0)).getPossibleValues().stream().map(t -> (String)t).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return object;
    }),
    RESPONSE_BUILDER_VARIANT(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "variant", Types.RESPONSE_BUILDER, Types.VARIANT), (object, arguments) -> {
        KnownResponseResultMethod.addHeader(object, "Content-Language");
        KnownResponseResultMethod.addHeader(object, "Content-Encoding");
        return object;
    }),
    RESPONSE_BUILDER_VARIANTS_LIST(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "variants", Types.RESPONSE_BUILDER, Types.LIST), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Vary")),
    RESPONSE_BUILDER_VARIANTS_ARRAY(MethodIdentifier.ofNonStatic(Types.RESPONSE_BUILDER, "variants", Types.RESPONSE_BUILDER, new Type(Variant[].class.getName())), (object, arguments) -> KnownResponseResultMethod.addHeader(object, "Vary")),
    RESPONSE_STATUS_ENUM(MethodIdentifier.ofStatic(Types.RESPONSE, "status", Types.RESPONSE_BUILDER, Types.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_STATUS_INT(MethodIdentifier.ofStatic(Types.RESPONSE, "status", Types.RESPONSE_BUILDER, Types.PRIMITIVE_INT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESPONSE_OK(MethodIdentifier.ofStatic(Types.RESPONSE, "ok", Types.RESPONSE_BUILDER, new Type[0]), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
    }),
    RESPONSE_OK_ENTITY(MethodIdentifier.ofStatic(Types.RESPONSE, "ok", Types.RESPONSE_BUILDER, Types.OBJECT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_OK_VARIANT(MethodIdentifier.ofStatic(Types.RESPONSE, "ok", Types.RESPONSE_BUILDER, Types.OBJECT, Types.VARIANT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
        KnownResponseResultMethod.addHeader(object, "Content-Language");
        return KnownResponseResultMethod.addHeader(object, "Content-Encoding");
    }),
    RESPONSE_OK_MEDIATYPE(MethodIdentifier.ofStatic(Types.RESPONSE, "ok", Types.RESPONSE_BUILDER, Types.OBJECT, new Type(MediaType.class.getName())), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(m -> (MediaType)m).map(m -> m.getType() + '/' + m.getSubtype()).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_OK_MEDIATYPE_STRING(MethodIdentifier.ofStatic(Types.RESPONSE, "ok", Types.RESPONSE_BUILDER, Types.OBJECT, Types.STRING), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.OK.getStatusCode());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(t -> (String)t).forEach(t -> KnownResponseResultMethod.addContentType(object, t));
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_ACCEPTED(MethodIdentifier.ofStatic(Types.RESPONSE, "accepted", Types.RESPONSE_BUILDER, new Type[0]), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.ACCEPTED.getStatusCode());
    }),
    RESPONSE_ACCEPTED_ENTITY(MethodIdentifier.ofStatic(Types.RESPONSE, "accepted", Types.RESPONSE_BUILDER, Types.OBJECT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.ACCEPTED.getStatusCode());
        return KnownResponseResultMethod.addEntity(object, (Element)arguments.get(0));
    }),
    RESPONSE_CREATED(MethodIdentifier.ofStatic(Types.RESPONSE, "created", Types.RESPONSE_BUILDER, Types.URI), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.CREATED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_NO_CONTENT(MethodIdentifier.ofStatic(Types.RESPONSE, "noContent", Types.RESPONSE_BUILDER, new Type[0]), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.NO_CONTENT.getStatusCode());
    }),
    RESPONSE_NOT_ACCEPTABLE(MethodIdentifier.ofStatic(Types.RESPONSE, "notAcceptable", Types.RESPONSE_BUILDER, Types.LIST), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_ACCEPTABLE.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Vary");
    }),
    RESPONSE_NOT_MODIFIED(MethodIdentifier.ofStatic(Types.RESPONSE, "notModified", Types.RESPONSE_BUILDER, new Type[0]), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
    }),
    RESPONSE_NOT_MODIFIED_ENTITYTAG(MethodIdentifier.ofStatic(Types.RESPONSE, "notModified", Types.RESPONSE_BUILDER, Types.ENTITY_TAG), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "ETag");
    }),
    RESPONSE_NOT_MODIFIED_ENTITYTAG_STRING(MethodIdentifier.ofStatic(Types.RESPONSE, "notModified", Types.RESPONSE_BUILDER, Types.STRING), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.NOT_MODIFIED.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "ETag");
    }),
    RESPONSE_SEE_OTHER(MethodIdentifier.ofStatic(Types.RESPONSE, "seeOther", Types.RESPONSE_BUILDER, Types.URI), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.SEE_OTHER.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_TEMPORARY_REDIRECT(MethodIdentifier.ofStatic(Types.RESPONSE, "temporaryRedirect", Types.RESPONSE_BUILDER, Types.URI), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        KnownResponseResultMethod.addStatus(object, Response.Status.TEMPORARY_REDIRECT.getStatusCode());
        return KnownResponseResultMethod.addHeader(object, "Location");
    }),
    RESPONSE_SERVER_ERROR(MethodIdentifier.ofStatic(Types.RESPONSE, "serverError", Types.RESPONSE_BUILDER, new Type[0]), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_EMPTY(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, new Type[0]), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_RESPONSE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(0)),
    WEB_APPLICATION_EXCEPTION_MESSAGE_RESPONSE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(1)),
    WEB_APPLICATION_EXCEPTION_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.PRIMITIVE_INT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.PRIMITIVE_INT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(0)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.THROWABLE), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.THROWABLE), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        return KnownResponseResultMethod.addStatus(object, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE_RESPONSE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.THROWABLE, Types.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(1)),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_RESPONSE(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.THROWABLE, Types.RESPONSE), (notAvailable, arguments) -> (Element)arguments.get(2)),
    WEB_APPLICATION_EXCEPTION_CAUSE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.THROWABLE, Types.PRIMITIVE_INT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.THROWABLE, Types.PRIMITIVE_INT), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(2)).getPossibleValues().stream().map(status -> (int)((Integer)status)).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_CAUSE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.THROWABLE, Types.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(1)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    WEB_APPLICATION_EXCEPTION_MESSAGE_CAUSE_RESPONSE_STATUS(MethodIdentifier.ofNonStatic(Types.WEB_APPLICATION_EXCEPTION, "<init>", Types.PRIMITIVE_VOID, Types.STRING, Types.THROWABLE, Types.RESPONSE_STATUS), (notAvailable, arguments) -> {
        Element object = new Element(Types.RESPONSE, new HttpResponse());
        ((Element)arguments.get(2)).getPossibleValues().stream().map(status -> ((Response.Status)status).getStatusCode()).forEach(s -> KnownResponseResultMethod.addStatus(object, s));
        return object;
    }),
    RESOURCE_CONTEXT_INIT(MethodIdentifier.ofNonStatic(Types.RESOURCE_CONTEXT, "getResource", Types.OBJECT, new Type(Class.class.getName())), (object, arguments) -> new Element(((Element)arguments.get(0)).getPossibleValues().stream().filter(s -> s instanceof String).map(s -> new Type((String)s)).collect(Collectors.toSet()), new Object[0])),
    RESOURCE_CONTEXT_GET(MethodIdentifier.ofNonStatic(Types.RESOURCE_CONTEXT, "initResource", Types.OBJECT, Types.OBJECT), (object, arguments) -> new Element(((Element)arguments.get(0)).getTypes(), new Object[0])),
    INTEGER_VALUE_OF(MethodIdentifier.ofStatic(Types.INTEGER, "valueOf", Types.PRIMITIVE_INT, Types.INTEGER), (object, arguments) -> new Element(Types.INTEGER, ((Element)arguments.get(0)).getPossibleValues().toArray())),
    LIST_STREAM(MethodIdentifier.ofNonStatic(Types.LIST, "stream", Types.STREAM, new Type[0]), (object, arguments) -> new Element(object.getTypes(), new Object[0])),
    LIST_FOR_EACH(MethodIdentifier.ofNonStatic(Types.LIST, "forEach", Types.PRIMITIVE_VOID, Types.CONSUMER), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    SET_STREAM(MethodIdentifier.ofNonStatic(Types.SET, "stream", Types.STREAM, new Type[0]), (object, arguments) -> new Element(object.getTypes(), new Object[0])),
    SET_FOR_EACH(MethodIdentifier.ofNonStatic(Types.SET, "forEach", Types.PRIMITIVE_VOID, Types.CONSUMER), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    STREAM_COLLECT(MethodIdentifier.ofNonStatic(Types.STREAM, "collect", Types.OBJECT, Types.SUPPLIER, Types.BI_CONSUMER, Types.BI_CONSUMER), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle && arguments.get(1) instanceof MethodHandle) {
            Element collectionElement = ((Method)arguments.get(0)).invoke(null, Collections.emptyList());
            ((Method)arguments.get(1)).invoke(null, Arrays.asList(collectionElement, object));
            return collectionElement;
        }
        return Element.EMPTY;
    }),
    STREAM_FOR_EACH(MethodIdentifier.ofNonStatic(Types.STREAM, "forEach", Types.PRIMITIVE_VOID, Types.CONSUMER), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            ((Method)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return null;
    }),
    STREAM_MAP(MethodIdentifier.ofNonStatic(Types.STREAM, "map", Types.STREAM, new Type(Function.class.getName())), (object, arguments) -> {
        if (arguments.get(0) instanceof MethodHandle) {
            return ((MethodHandle)arguments.get(0)).invoke(null, Collections.singletonList(object));
        }
        return Element.EMPTY;
    });

    private final MethodIdentifier identifier;
    private final BiFunction<Element, List<Element>, Element> function;

    private KnownResponseResultMethod(MethodIdentifier identifier, BiFunction<Element, List<Element>, Element> function) {
        this.identifier = identifier;
        this.function = function;
    }

    @Override
    public Element invoke(Element object, List<Element> arguments) {
        if (arguments.size() != this.identifier.getParameters().size()) {
            throw new IllegalArgumentException("Method arguments do not match expected signature!");
        }
        return this.function.apply(object, arguments);
    }

    @Override
    public boolean matches(MethodIdentifier identifier) {
        return this.identifier.equals(identifier);
    }

    private static Element addHeader(Element object, String header) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getHeaders().add(header));
        return object;
    }

    private static Element addEntity(Element object, Element argument) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> {
            r.getEntityTypes().addAll(argument.getTypes());
            argument.getPossibleValues().stream().filter(j -> j instanceof JsonValue).map(j -> (JsonValue)j).forEach(j -> r.getInlineEntities().add((JsonValue)j));
        });
        return object;
    }

    private static Element addStatus(Element object, Integer status) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getStatuses().add(status));
        return object;
    }

    private static Element addContentType(Element object, String type) {
        object.getPossibleValues().stream().filter(r -> r instanceof HttpResponse).map(r -> (HttpResponse)r).forEach(r -> r.getContentTypes().add(type));
        return object;
    }
}

