/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation;

import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.KnownJsonResultMethod;
import com.sebastian_daschner.jaxrs_analyzer.analysis.bytecode.simulation.KnownResponseResultMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.IdentifiableMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.Method;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.MethodIdentifier;
import com.sebastian_daschner.jaxrs_analyzer.model.methods.ProjectMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import java.util.stream.Stream;

public class MethodPool {
    private static final MethodPool INSTANCE = new MethodPool();
    private static final Function<MethodIdentifier, Method> DEFAULT_METHOD = identifier -> (object, arguments) -> {
        if (!Types.PRIMITIVE_VOID.equals(identifier.getReturnType())) {
            return new Element(identifier.getReturnType(), new Object[0]);
        }
        return null;
    };
    private final List<IdentifiableMethod> availableMethods = new LinkedList<IdentifiableMethod>();
    private final ReadWriteLock readWriteLock;

    private MethodPool() {
        Stream.of(KnownResponseResultMethod.values()).forEach(this.availableMethods::add);
        Stream.of(KnownJsonResultMethod.values()).forEach(this.availableMethods::add);
        this.readWriteLock = new ReentrantReadWriteLock();
    }

    public void addProjectMethod(ProjectMethod method) {
        this.readWriteLock.writeLock().lock();
        try {
            this.availableMethods.add(method);
        }
        finally {
            this.readWriteLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method get(MethodIdentifier identifier) {
        this.readWriteLock.readLock().lock();
        try {
            Optional<IdentifiableMethod> method = this.availableMethods.stream().filter(m -> m.matches(identifier)).findAny();
            if (method.isPresent()) {
                Method method2 = method.get();
                return method2;
            }
        }
        finally {
            this.readWriteLock.readLock().unlock();
        }
        return DEFAULT_METHOD.apply(identifier);
    }

    public static MethodPool getInstance() {
        return INSTANCE;
    }
}

