/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.AnnotationInterpreter;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.MethodFinder;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.ResourceMethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.project.methods.SubResourceLocatorMethodContentAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.HttpResponse;
import com.sebastian_daschner.jaxrs_analyzer.model.results.ClassResult;
import com.sebastian_daschner.jaxrs_analyzer.model.results.MethodResult;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;

public class MethodAnalyzer {
    private static final Class<?>[] RELEVANT_METHOD_ANNOTATIONS = new Class[]{Path.class, GET.class, PUT.class, POST.class, DELETE.class, OPTIONS.class, HEAD.class};
    private static final Class<?>[] RELEVANT_PARAMETER_ANNOTATIONS = new Class[]{MatrixParam.class, QueryParam.class, PathParam.class, CookieParam.class, HeaderParam.class, FormParam.class, Context.class};
    private final Lock lock = new ReentrantLock();
    private final ResourceMethodContentAnalyzer resourceMethodAnalyzer = new ResourceMethodContentAnalyzer();
    private final SubResourceLocatorMethodContentAnalyzer subResourceLocatorMethodAnalyzer = new SubResourceLocatorMethodContentAnalyzer();
    private List<CtClass> superClasses;
    private CtMethod annotatedSuperMethod;
    private CtMethod method;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodResult analyze(CtMethod ctMethod) {
        this.lock.lock();
        try {
            this.method = ctMethod;
            this.determineAnnotatedSuperMethod();
            if (!this.isRelevant()) {
                MethodResult methodResult = null;
                return methodResult;
            }
            MethodResult methodResult = this.analyzeInternal();
            return methodResult;
        }
        catch (Exception e) {
            LogProvider.error("Could not analyze the method: " + this.method);
            LogProvider.debug(e);
            MethodResult methodResult = null;
            return methodResult;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void determineAnnotatedSuperMethod() {
        this.superClasses = new LinkedList<CtClass>();
        try {
            this.determineSuperDeclarations();
        }
        catch (NotFoundException e) {
            LogProvider.error("Could not determine super classes");
            LogProvider.debug(e);
        }
        this.annotatedSuperMethod = MethodFinder.findFirstMethod(this.superClasses, this.method.getSignature(), MethodAnalyzer::hasJaxRsAnnotations);
    }

    private void determineSuperDeclarations() throws NotFoundException {
        CtClass ctClass = this.method.getDeclaringClass();
        LinkedBlockingQueue<CtClass> classesToCheck = new LinkedBlockingQueue<CtClass>();
        do {
            if (ctClass.getSuperclass() != null && !Object.class.getName().equals(ctClass.getSuperclass().getName())) {
                classesToCheck.add(ctClass.getSuperclass());
            }
            Stream.of(ctClass.getInterfaces()).forEach(classesToCheck::add);
            if (this.method.getDeclaringClass().equals(ctClass)) continue;
            this.superClasses.add(ctClass);
        } while ((ctClass = (CtClass)classesToCheck.poll()) != null);
    }

    private boolean isRelevant() {
        if (JavaUtils.isInitializerName(this.method.getName())) {
            return false;
        }
        if (MethodAnalyzer.hasJaxRsAnnotations(this.method)) {
            return true;
        }
        return this.annotatedSuperMethod != null;
    }

    private MethodResult analyzeInternal() throws BadBytecode {
        MethodResult methodResult = new MethodResult();
        this.analyzeMethodInformation(this.method, methodResult);
        if (methodResult.getHttpMethod() == null) {
            this.analyzeSubResourceLocator(methodResult);
            return methodResult;
        }
        int modifiers = this.method.getModifiers();
        if (!Modifier.isNative(modifiers) && !Modifier.isAbstract(modifiers)) {
            this.analyzeMethodContent(methodResult);
        } else {
            Type returnType = JavaUtils.getReturnType(this.method, null);
            if (!Types.RESPONSE.equals(returnType) && !Types.PRIMITIVE_VOID.equals(returnType)) {
                HttpResponse emptyResponse = new HttpResponse();
                emptyResponse.getEntityTypes().add(returnType);
                methodResult.getResponses().add(emptyResponse);
            }
        }
        return methodResult;
    }

    private void analyzeMethodInformation(CtMethod ctMethod, MethodResult methodResult) throws BadBytecode {
        if (!MethodAnalyzer.hasJaxRsAnnotations(ctMethod) && this.annotatedSuperMethod != null) {
            this.analyzeMethodInformation(this.annotatedSuperMethod, methodResult);
            return;
        }
        for (Object annotation : ctMethod.getAvailableAnnotations()) {
            AnnotationInterpreter.interpretMethodAnnotation(annotation, methodResult);
        }
        this.analyzeMethodParameters(ctMethod, methodResult);
    }

    private void analyzeMethodParameters(CtMethod ctMethod, MethodResult methodResult) throws BadBytecode {
        List<Type> parameterTypes = JavaUtils.getParameterTypes(ctMethod);
        Object[][] parameterAnnotations = ctMethod.getAvailableParameterAnnotations();
        for (int index = 0; index < parameterTypes.size(); ++index) {
            Type parameterType = parameterTypes.get(index);
            if (this.isEntityParameter(ctMethod, index)) {
                methodResult.setRequestBodyType(parameterType);
                continue;
            }
            for (Object annotation : parameterAnnotations[index]) {
                AnnotationInterpreter.interpretMethodParameterAnnotation(annotation, parameterType, methodResult);
            }
        }
    }

    private void analyzeSubResourceLocator(MethodResult methodResult) {
        ClassResult classResult = new ClassResult();
        methodResult.setSubResource(classResult);
        this.subResourceLocatorMethodAnalyzer.analyze(this.method, classResult);
    }

    private void analyzeMethodContent(MethodResult methodResult) {
        this.resourceMethodAnalyzer.analyze(this.method, methodResult);
    }

    private boolean isEntityParameter(CtMethod ctMethod, int index) {
        for (Object annotation : ctMethod.getAvailableParameterAnnotations()[index]) {
            if (!Stream.of(RELEVANT_PARAMETER_ANNOTATIONS).anyMatch(c -> c.isAssignableFrom(annotation.getClass()))) continue;
            return false;
        }
        return true;
    }

    private static boolean hasJaxRsAnnotations(CtMethod ctMethod) {
        for (Object annotation : ctMethod.getAvailableAnnotations()) {
            if (!Stream.of(RELEVANT_METHOD_ANNOTATIONS).anyMatch(c -> c.isAssignableFrom(annotation.getClass()))) continue;
            return true;
        }
        Object[] objectArray = ctMethod.getAvailableParameterAnnotations();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            Object annotations;
            for (Object annotation : annotations = objectArray[i]) {
                if (!Stream.of(RELEVANT_PARAMETER_ANNOTATIONS).anyMatch(c -> c.isAssignableFrom(annotation.getClass()))) continue;
                return true;
            }
        }
        return false;
    }
}

