/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.model.elements.Element;
import com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonValue;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Set;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

final class JsonMapper {
    private JsonMapper() {
        throw new UnsupportedOperationException();
    }

    static javax.json.JsonValue map(JsonValue jsonValue) {
        if (jsonValue instanceof com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray) {
            return JsonMapper.map((com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray)jsonValue);
        }
        return JsonMapper.map((com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject)jsonValue);
    }

    private static JsonArray map(com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonArray jsonArray) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        jsonArray.getElements().stream().forEach(e -> JsonMapper.addToArray(builder, e));
        return builder.build();
    }

    private static void addToArray(JsonArrayBuilder builder, Element value) {
        if (value.getTypes().contains(Types.STRING)) {
            builder.add("string");
        }
        if (value.getTypes().stream().anyMatch(Types.INTEGER_TYPES::contains)) {
            builder.add(0);
        }
        if (value.getTypes().stream().anyMatch(Types.DOUBLE_TYPES::contains)) {
            builder.add(0.0);
        }
        if (value.getTypes().contains(Types.BOOLEAN) || value.getTypes().contains(Types.PRIMITIVE_BOOLEAN)) {
            builder.add(false);
        }
        if (value.getTypes().stream().anyMatch(Types.JSON_TYPES::contains)) {
            value.getPossibleValues().stream().filter(v -> v instanceof JsonValue).findFirst().ifPresent(v -> builder.add(JsonMapper.map((JsonValue)v)));
        }
    }

    private static JsonObject map(com.sebastian_daschner.jaxrs_analyzer.model.elements.JsonObject jsonObject) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        jsonObject.getStructure().entrySet().stream().forEach(e -> JsonMapper.addToObject(builder, (String)e.getKey(), (Element)e.getValue()));
        return builder.build();
    }

    private static void addToObject(JsonObjectBuilder builder, String key, Element value) {
        if (value.getTypes().stream().anyMatch(Types.JSON_TYPES::contains)) {
            value.getPossibleValues().stream().filter(v -> v instanceof JsonValue).findFirst().ifPresent(v -> builder.add(key, JsonMapper.map((JsonValue)v)));
            return;
        }
        JsonMapper.addToObject(builder, key, value.getTypes());
    }

    private static void addToObject(JsonObjectBuilder builder, String key, Set<Type> types) {
        if (types.contains(Types.STRING)) {
            builder.add(key, "string");
        }
        if (types.stream().anyMatch(Types.INTEGER_TYPES::contains)) {
            builder.add(key, 0);
        }
        if (types.stream().anyMatch(Types.DOUBLE_TYPES::contains)) {
            builder.add(key, 0.0);
        }
        if (types.contains(Types.BOOLEAN) || types.contains(Types.PRIMITIVE_BOOLEAN)) {
            builder.add(key, false);
        }
    }

    static void addToObject(JsonObjectBuilder builder, String key, Type type, Function<Type, javax.json.JsonValue> defaultBehavior) {
        if (Types.STRING.equals(type)) {
            builder.add(key, "string");
            return;
        }
        if (Types.BOOLEAN.equals(type) || Types.PRIMITIVE_BOOLEAN.equals(type)) {
            builder.add(key, false);
            return;
        }
        if (Types.INTEGER_TYPES.contains(type)) {
            builder.add(key, 0);
            return;
        }
        if (Types.DOUBLE_TYPES.contains(type)) {
            builder.add(key, 0.0);
            return;
        }
        if (type.isAssignableTo(Types.DATE) || type.isAssignableTo(Types.TEMPORAL_ACCESSOR)) {
            builder.add(key, "date");
            return;
        }
        if (type.isAssignableTo(Types.MAP)) {
            builder.add(key, Json.createObjectBuilder().build());
            return;
        }
        builder.add(key, defaultBehavior.apply(type));
    }

    static void addToArray(JsonArrayBuilder builder, Type type, Function<Type, javax.json.JsonValue> defaultBehavior) {
        if (Types.STRING.equals(type)) {
            builder.add("string");
            return;
        }
        if (Types.BOOLEAN.equals(type) || Types.PRIMITIVE_BOOLEAN.equals(type)) {
            builder.add(false);
            return;
        }
        if (Types.INTEGER_TYPES.contains(type)) {
            builder.add(0);
            return;
        }
        if (Types.DOUBLE_TYPES.contains(type)) {
            builder.add(0.0);
            return;
        }
        builder.add(defaultBehavior.apply(type));
    }
}

