/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.analysis.results;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.JsonMapper;
import com.sebastian_daschner.jaxrs_analyzer.analysis.results.ResponseTypeNormalizer;
import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.JavaUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.Pair;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.TypeRepresentation;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;

class TypeAnalyzer {
    private static final String[] NAMES_TO_IGNORE = new String[]{"getClass"};
    private static final JsonString EMPTY_JSON_STRING = new JsonString(){
        private static final String TYPE = "string";

        @Override
        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.STRING;
        }

        @Override
        public String getString() {
            return TYPE;
        }

        @Override
        public CharSequence getChars() {
            return TYPE;
        }
    };
    private final Lock lock = new ReentrantLock();
    private final List<Type> typesPath = new LinkedList<Type>();
    private Type type;

    TypeAnalyzer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TypeRepresentation analyze(Type type) {
        this.lock.lock();
        try {
            this.typesPath.clear();
            this.type = ResponseTypeNormalizer.normalizeResponseWrapper(type);
            boolean collection = this.type.isAssignableTo(Types.COLLECTION);
            if (!collection && this.isJDKType()) {
                TypeRepresentation typeRepresentation = new TypeRepresentation(this.type);
                return typeRepresentation;
            }
            TypeRepresentation representation = new TypeRepresentation(ResponseTypeNormalizer.normalize(this.type));
            representation.getRepresentations().put("application/json", this.analyzeInternal(this.type));
            TypeRepresentation typeRepresentation = representation;
            return typeRepresentation;
        }
        finally {
            this.lock.unlock();
        }
    }

    private boolean isJDKType() {
        return this.type.toString().startsWith("java");
    }

    private JsonValue analyzeInternal(Type type) {
        if (this.typesPath.contains(type)) {
            return Json.createObjectBuilder().build();
        }
        this.typesPath.add(type);
        if (type.isAssignableTo(Types.COLLECTION)) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            JsonMapper.addToArray(arrayBuilder, ResponseTypeNormalizer.normalizeCollection(type), this::analyzeInternal);
            return arrayBuilder.build();
        }
        try {
            return this.analyzeClass(type);
        }
        catch (Exception e) {
            LogProvider.error("Could not analyze class for type analysis: " + e.getMessage());
            LogProvider.debug(e);
            return Json.createObjectBuilder().build();
        }
    }

    private JsonValue analyzeClass(Type type) throws ClassNotFoundException {
        CtClass ctClass = type.getCtClass();
        if (ctClass.isEnum()) {
            return EMPTY_JSON_STRING;
        }
        XmlAccessType value = ctClass.hasAnnotation(XmlAccessorType.class) ? ((XmlAccessorType)ctClass.getAnnotation(XmlAccessorType.class)).value() : XmlAccessType.PUBLIC_MEMBER;
        List relevantFields = Stream.of(ctClass.getDeclaredFields()).filter(f -> TypeAnalyzer.isRelevant(f, value)).collect(Collectors.toList());
        List relevantGetters = Stream.of(ctClass.getDeclaredMethods()).filter(m -> TypeAnalyzer.isRelevant(m, value)).collect(Collectors.toList());
        JsonObjectBuilder builder = Json.createObjectBuilder();
        relevantFields.stream().map(f -> TypeAnalyzer.mapField(f, type)).filter(Objects::nonNull).forEach(p -> JsonMapper.addToObject(builder, (String)p.getLeft(), (Type)p.getRight(), this::analyzeInternal));
        relevantGetters.stream().map(g -> TypeAnalyzer.mapGetter(g, type)).filter(Objects::nonNull).forEach(p -> JsonMapper.addToObject(builder, (String)p.getLeft(), (Type)p.getRight(), this::analyzeInternal));
        return builder.build();
    }

    private static boolean isRelevant(CtField field, XmlAccessType accessType) {
        if (JavaUtils.isSynthetic(field)) {
            return false;
        }
        if (field.hasAnnotation(XmlElement.class)) {
            return true;
        }
        int modifiers = field.getModifiers();
        if (accessType == XmlAccessType.FIELD) {
            return !Modifier.isTransient(modifiers) && !Modifier.isStatic(modifiers) && !field.hasAnnotation(XmlTransient.class);
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(modifiers) && !Modifier.isStatic(modifiers) && !field.hasAnnotation(XmlTransient.class);
        }
        return false;
    }

    private static boolean isRelevant(CtMethod method, XmlAccessType accessType) {
        if (JavaUtils.isSynthetic(method) || !TypeAnalyzer.isGetter(method)) {
            return false;
        }
        if (method.hasAnnotation(XmlElement.class)) {
            return true;
        }
        if (accessType == XmlAccessType.PROPERTY) {
            return !method.hasAnnotation(XmlTransient.class);
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(method.getModifiers()) && !method.hasAnnotation(XmlTransient.class);
        }
        return false;
    }

    private static boolean isGetter(CtMethod method) {
        if (Modifier.isStatic(method.getModifiers())) {
            return false;
        }
        String name = method.getName();
        if (Stream.of(NAMES_TO_IGNORE).anyMatch(n -> n.equals(name))) {
            return false;
        }
        if (name.startsWith("get") && name.length() > 3) {
            return !method.getSignature().endsWith(")V");
        }
        return name.startsWith("is") && name.length() > 2 && method.getSignature().endsWith(")Z");
    }

    private static Pair<String, Type> mapField(CtField field, Type containedType) {
        Type type = JavaUtils.getFieldType(field, containedType);
        if (type == null) {
            return null;
        }
        return Pair.of(field.getName(), type);
    }

    private static Pair<String, Type> mapGetter(CtMethod method, Type containedType) {
        Type returnType = JavaUtils.getReturnType(method, containedType);
        if (returnType == null) {
            return null;
        }
        return Pair.of(TypeAnalyzer.normalizeGetter(method.getName()), returnType);
    }

    private static String normalizeGetter(String name) {
        int size = name.startsWith("is") ? 2 : 3;
        char[] chars = name.substring(size).toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }
}

