/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.asciidoc.AsciiDocBackend;
import com.sebastian_daschner.jaxrs_analyzer.backend.plaintext.PlainTextBackend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerBackend;
import java.util.function.Supplier;

public enum BackendType {
    PLAINTEXT("Plain text", PlainTextBackend::new),
    ASCIIDOC("AsciiDoc", AsciiDocBackend::new),
    SWAGGER("Swagger", SwaggerBackend::new);

    private final String name;
    private final Supplier<Backend> backendSupplier;

    private BackendType(String name, Supplier<Backend> backendSupplier) {
        this.name = name;
        this.backendSupplier = backendSupplier;
    }

    public String getName() {
        return this.name;
    }

    public Supplier<Backend> getBackendSupplier() {
        return this.backendSupplier;
    }

    public static BackendType getByNameIgnoreCase(String name) {
        for (BackendType backend : BackendType.values()) {
            if (!backend.name().equalsIgnoreCase(name)) continue;
            return backend;
        }
        return null;
    }
}

