/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.plaintext;

import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.StringUtils;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.ComparatorUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.MethodParameters;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Project;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Response;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.json.JsonValue;

public class PlainTextBackend
implements Backend {
    private static final String REST_HEADER = "REST resources of ";
    private static final String TYPE_WILDCARD = "*/*";
    private final Lock lock = new ReentrantLock();
    private StringBuilder builder;
    private Resources resources;
    private String projectName;
    private String projectVersion;

    @Override
    public String render(Project project) {
        this.lock.lock();
        try {
            this.builder = new StringBuilder();
            this.resources = project.getResources();
            this.projectName = project.getName();
            this.projectVersion = project.getVersion();
            String string = this.renderInternal();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    private String renderInternal() {
        this.appendHeader();
        this.resources.getResources().stream().sorted().forEach(this::appendResource);
        return this.builder.toString();
    }

    private void appendHeader() {
        this.builder.append(REST_HEADER).append(this.projectName).append(":\n").append(this.projectVersion).append("\n\n");
    }

    private void appendResource(String resource) {
        this.resources.getMethods(resource).stream().sorted(Comparator.comparing(ResourceMethod::getMethod)).forEach(resourceMethod -> {
            this.appendMethod(this.resources.getBasePath(), resource, (ResourceMethod)resourceMethod);
            this.appendRequest((ResourceMethod)resourceMethod);
            this.appendResponse((ResourceMethod)resourceMethod);
            this.appendResourceEnd();
        });
    }

    private void appendMethod(String baseUri, String resource, ResourceMethod resourceMethod) {
        this.builder.append((Object)resourceMethod.getMethod()).append(' ');
        if (!StringUtils.isBlank(baseUri)) {
            this.builder.append(baseUri).append('/');
        }
        this.builder.append(resource).append(":\n");
    }

    private void appendRequest(ResourceMethod resourceMethod) {
        this.builder.append(" Request:\n");
        if (resourceMethod.getRequestBody() != null) {
            this.builder.append("  Content-Type: ");
            this.builder.append(resourceMethod.getRequestMediaTypes().isEmpty() ? TYPE_WILDCARD : PlainTextBackend.toString(resourceMethod.getRequestMediaTypes()));
            this.builder.append('\n');
            this.builder.append("  Request Body: ").append(resourceMethod.getRequestBody().getType()).append('\n');
            resourceMethod.getRequestBody().getRepresentations().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> this.builder.append("   ").append((String)e.getKey()).append(": ").append(e.getValue()).append('\n'));
        } else {
            this.builder.append("  No body\n");
        }
        MethodParameters parameters = resourceMethod.getMethodParameters();
        this.appendParams("  Path Param: ", parameters.getPathParams());
        this.appendParams("  Query Param: ", parameters.getQueryParams());
        this.appendParams("  Form Param: ", parameters.getFormParams());
        this.appendParams("  Header Param: ", parameters.getHeaderParams());
        this.appendParams("  Cookie Param: ", parameters.getCookieParams());
        this.appendParams("  Matrix Param: ", parameters.getMatrixParams());
        this.builder.append('\n');
    }

    private void appendParams(String name, Map<String, Type> parameters) {
        parameters.entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> this.builder.append(name).append((String)e.getKey()).append(", ").append(e.getValue()).append('\n'));
    }

    private void appendResponse(ResourceMethod resourceMethod) {
        this.builder.append(" Response:\n");
        this.builder.append("  Content-Type: ");
        this.builder.append(resourceMethod.getResponseMediaTypes().isEmpty() ? TYPE_WILDCARD : PlainTextBackend.toString(resourceMethod.getResponseMediaTypes()));
        this.builder.append('\n');
        resourceMethod.getResponses().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).forEach(e -> {
            this.builder.append("  Status Codes: ").append(e.getKey()).append('\n');
            Response response = (Response)e.getValue();
            if (!response.getHeaders().isEmpty()) {
                this.builder.append("   Header: ").append(response.getHeaders().stream().sorted().collect(Collectors.joining(", ")));
                this.builder.append('\n');
            }
            if (response.getResponseBody() != null) {
                this.builder.append("   Response Body: ").append(response.getResponseBody().getType());
                response.getResponseBody().getRepresentations().entrySet().stream().sorted(ComparatorUtils.mapKeyComparator()).filter(r -> r.getValue() instanceof JsonValue).forEach(r -> this.builder.append(" (").append((String)r.getKey()).append("): \n").append(r.getValue()));
                this.builder.append('\n');
            }
            this.builder.append('\n');
        });
    }

    private void appendResourceEnd() {
        this.builder.append("\n");
    }

    private static String toString(Set<String> set) {
        return set.stream().sorted().map(Object::toString).collect(Collectors.joining(", "));
    }
}

