/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.backend.swagger;

import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerType;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import javax.json.JsonValue;

final class SwaggerUtils {
    private SwaggerUtils() {
        throw new UnsupportedOperationException();
    }

    static SwaggerType toSwaggerType(Type type) {
        if (Types.STRING.equals(type)) {
            return SwaggerType.STRING;
        }
        if (Types.BOOLEAN.equals(type) || Types.PRIMITIVE_BOOLEAN.equals(type)) {
            return SwaggerType.BOOLEAN;
        }
        if (Types.INTEGER_TYPES.contains(type)) {
            return SwaggerType.INTEGER;
        }
        if (Types.DOUBLE_TYPES.contains(type)) {
            return SwaggerType.NUMBER;
        }
        if (type.getCtClass().isArray()) {
            return SwaggerType.ARRAY;
        }
        return SwaggerType.OBJECT;
    }

    static SwaggerType toSwaggerType(JsonValue.ValueType type) {
        switch (type) {
            case ARRAY: {
                return SwaggerType.ARRAY;
            }
            case OBJECT: {
                return SwaggerType.OBJECT;
            }
            case STRING: {
                return SwaggerType.STRING;
            }
            case NUMBER: {
                return SwaggerType.NUMBER;
            }
            case TRUE: 
            case FALSE: {
                return SwaggerType.BOOLEAN;
            }
        }
        return SwaggerType.NULL;
    }
}

