/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.instructions;

import com.sebastian_daschner.jaxrs_analyzer.analysis.utils.StringUtils;
import com.sebastian_daschner.jaxrs_analyzer.model.instructions.Instruction;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import java.util.Objects;

public abstract class LoadStoreInstruction
implements Instruction {
    private final int number;
    private final Type variableType;
    private final String name;

    protected LoadStoreInstruction(int number, Type variableType, String name) {
        Objects.requireNonNull(variableType);
        StringUtils.requireNonBlank(name);
        this.number = number;
        this.variableType = variableType;
        this.name = name;
    }

    public int getNumber() {
        return this.number;
    }

    public Type getVariableType() {
        return this.variableType;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoadStoreInstruction that = (LoadStoreInstruction)o;
        if (this.number != that.number) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.variableType.equals(that.variableType)) {
            return false;
        }
        if (this.getStackSizeDifference() != that.getStackSizeDifference()) {
            return false;
        }
        return this.getType() == that.getType();
    }

    public int hashCode() {
        int result = this.number;
        result = 31 * result + this.getStackSizeDifference();
        result = 31 * result + (this.getType() != null ? this.getType().ordinal() : 0);
        result = 31 * result + this.variableType.hashCode();
        result = 31 * result + this.name.hashCode();
        return result;
    }

    public String toString() {
        return "LoadStoreInstruction{type='" + (Object)((Object)this.getType()) + '\'' + ", number=" + this.number + '\'' + ", variableType=" + this.variableType + '\'' + ", name=" + this.name + '}';
    }
}

