/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.methods;

import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class MethodIdentifier {
    private final Type containingClass;
    private final String methodName;
    private final Type returnType;
    private final boolean staticMethod;
    private final List<Type> parameters;

    private MethodIdentifier(Type containingClass, String methodName, Type returnType, boolean staticMethod, List<Type> parameters) {
        Objects.requireNonNull(containingClass);
        Objects.requireNonNull(methodName);
        Objects.requireNonNull(returnType);
        for (Type parameterType : parameters) {
            Objects.requireNonNull(parameterType);
        }
        this.containingClass = containingClass;
        this.methodName = methodName;
        this.returnType = returnType;
        this.staticMethod = staticMethod;
        this.parameters = parameters;
    }

    public Type getContainingClass() {
        return this.containingClass;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Type getReturnType() {
        return this.returnType;
    }

    public boolean isStaticMethod() {
        return this.staticMethod;
    }

    public List<Type> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MethodIdentifier that = (MethodIdentifier)o;
        if (this.staticMethod != that.staticMethod) {
            return false;
        }
        if (!this.containingClass.equals(that.containingClass)) {
            return false;
        }
        if (!this.methodName.equals(that.methodName)) {
            return false;
        }
        if (!this.returnType.equals(that.returnType)) {
            return false;
        }
        return this.parameters.equals(that.parameters);
    }

    public int hashCode() {
        int result = this.containingClass.hashCode();
        result = 31 * result + this.methodName.hashCode();
        result = 31 * result + this.returnType.hashCode();
        result = 31 * result + (this.staticMethod ? 1 : 0);
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return "MethodIdentifier{containingClass=" + this.containingClass + ", methodName='" + this.methodName + '\'' + ", returnType=" + this.returnType + ", staticMethod=" + this.staticMethod + ", parameters=" + this.parameters + '}';
    }

    public static MethodIdentifier of(Type containingClass, String methodName, Type returnType, boolean staticMethod, Type ... parameterTypes) {
        LinkedList<Type> parameters = new LinkedList<Type>();
        if (parameterTypes != null && parameterTypes.length > 0) {
            Stream.of(parameterTypes).forEach(parameters::add);
        }
        return new MethodIdentifier(containingClass, methodName, returnType, staticMethod, parameters);
    }

    public static MethodIdentifier ofNonStatic(Type containingClass, String methodName, Type returnType, Type ... parameterTypes) {
        LinkedList<Type> parameters = new LinkedList<Type>();
        if (parameterTypes != null && parameterTypes.length > 0) {
            Stream.of(parameterTypes).forEach(parameters::add);
        }
        return new MethodIdentifier(containingClass, methodName, returnType, false, parameters);
    }

    public static MethodIdentifier ofStatic(Type containingClass, String methodName, Type returnType, Type ... parameterTypes) {
        LinkedList<Type> parameters = new LinkedList<Type>();
        if (parameterTypes != null && parameterTypes.length > 0) {
            Stream.of(parameterTypes).forEach(parameters::add);
        }
        return new MethodIdentifier(containingClass, methodName, returnType, true, parameters);
    }
}

