/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.rest;

import com.sebastian_daschner.jaxrs_analyzer.model.rest.ResourceMethod;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Resources {
    private final Map<String, Set<ResourceMethod>> resources = new HashMap<String, Set<ResourceMethod>>();
    private String basePath;

    public void addMethod(String resource, ResourceMethod method) {
        this.resources.putIfAbsent(resource, new HashSet());
        this.resources.get(resource).add(method);
    }

    public Set<String> getResources() {
        return Collections.unmodifiableSet(this.resources.keySet());
    }

    public Set<ResourceMethod> getMethods(String resource) {
        return Collections.unmodifiableSet(this.resources.get(resource));
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Resources resources1 = (Resources)o;
        if (!this.resources.equals(resources1.resources)) {
            return false;
        }
        return !(this.basePath == null ? resources1.basePath != null : !this.basePath.equals(resources1.basePath));
    }

    public int hashCode() {
        int result = this.resources.hashCode();
        result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Resources{resources=" + this.resources + ", basePath='" + this.basePath + '\'' + '}';
    }
}

