/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.types;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.model.types.TypeExtractor;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;

public class Type {
    private final CtClass ctClass;
    private final List<Type> typeParameters;

    public Type(String type) {
        try {
            this.ctClass = TypeExtractor.toErasuredClass(type);
            this.typeParameters = TypeExtractor.toTypeParameters(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Type(CtClass ctClass) {
        try {
            this.ctClass = TypeExtractor.toErasuredClass(ctClass.getName());
            this.typeParameters = Collections.emptyList();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Type(SignatureAttribute.Type sigType) {
        this(sigType, null, null, null);
    }

    public Type(SignatureAttribute.Type sigType, SignatureAttribute.ClassSignature genericClassSignature, Type containingType, SignatureAttribute.MethodSignature genericMethodSignature) {
        String type = Type.getType(sigType, genericClassSignature, containingType, genericMethodSignature);
        try {
            this.ctClass = TypeExtractor.toErasuredClass(type);
            this.typeParameters = TypeExtractor.toTypeParameters(type);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getType(SignatureAttribute.Type type, SignatureAttribute.ClassSignature genericClassSignature, Type containingType, SignatureAttribute.MethodSignature genericMethodSignature) {
        if (type instanceof SignatureAttribute.ClassType) {
            StringBuilder builder = new StringBuilder();
            if (type instanceof SignatureAttribute.NestedClassType) {
                SignatureAttribute.NestedClassType nestedClassType = (SignatureAttribute.NestedClassType)type;
                LinkedList<SignatureAttribute.ClassType> declaringClasses = new LinkedList<SignatureAttribute.ClassType>();
                for (SignatureAttribute.ClassType declaringClass = nestedClassType.getDeclaringClass(); declaringClass != null; declaringClass = declaringClass.getDeclaringClass()) {
                    declaringClasses.add(declaringClass);
                }
                Collections.reverse(declaringClasses);
                declaringClasses.forEach(c -> builder.append(c.getName()).append('$'));
                builder.append(nestedClassType.getName());
            } else {
                builder.append(((SignatureAttribute.ClassType)type).getName());
            }
            SignatureAttribute.ClassType classType = (SignatureAttribute.ClassType)type;
            if (classType.getTypeArguments() != null) {
                builder.append('<');
                for (int i = 0; i < classType.getTypeArguments().length; ++i) {
                    builder.append(Type.getTypeArgument(classType.getTypeArguments()[i], genericClassSignature, containingType, genericMethodSignature));
                    if (i >= classType.getTypeArguments().length - 1) continue;
                    builder.append(',');
                }
                builder.append('>');
            }
            return builder.toString();
        }
        if (type instanceof SignatureAttribute.ArrayType) {
            SignatureAttribute.ArrayType arrayType = (SignatureAttribute.ArrayType)type;
            StringBuilder builder = new StringBuilder(Type.getType(arrayType.getComponentType(), genericClassSignature, containingType, genericMethodSignature));
            for (int i = 0; i < arrayType.getDimension(); ++i) {
                builder.append("[]");
            }
            return builder.toString();
        }
        if (type instanceof SignatureAttribute.TypeVariable) {
            int index;
            SignatureAttribute.TypeVariable typeVariable = (SignatureAttribute.TypeVariable)type;
            if (genericMethodSignature != null && (index = Type.getTypeVariableIndex(genericMethodSignature.getTypeParameters(), typeVariable.getName())) < genericMethodSignature.getTypeParameters().length) {
                return Types.OBJECT.toString();
            }
            if (genericClassSignature != null && (index = Type.getTypeVariableIndex(genericClassSignature.getParameters(), typeVariable.getName())) < genericClassSignature.getParameters().length) {
                return containingType != null && index < containingType.getTypeParameters().size() ? containingType.getTypeParameters().get(index).toString() : Types.OBJECT.toString();
            }
        }
        return type.toString();
    }

    private static int getTypeVariableIndex(SignatureAttribute.TypeParameter[] typeParameters, String typeVariableName) {
        int index;
        for (index = 0; index < typeParameters.length && !typeParameters[index].getName().equals(typeVariableName); ++index) {
        }
        return index;
    }

    private static String getTypeArgument(SignatureAttribute.TypeArgument typeArgument, SignatureAttribute.ClassSignature genericClassSignature, Type containingType, SignatureAttribute.MethodSignature genericMethodSignature) {
        if (typeArgument.getKind() == '*') {
            return Types.OBJECT.toString();
        }
        return Type.getType(typeArgument.getType(), genericClassSignature, containingType, genericMethodSignature);
    }

    public CtClass getCtClass() {
        return this.ctClass;
    }

    public List<Type> getTypeParameters() {
        return this.typeParameters;
    }

    public boolean isAssignableTo(Type type) {
        if (this.equals(type)) {
            return true;
        }
        if (this.ctClass.equals(type.ctClass) && (this.typeParameters.isEmpty() || type.typeParameters.isEmpty())) {
            return true;
        }
        try {
            CtClass superclass = this.ctClass.getSuperclass();
            if (superclass != null && !Types.OBJECT.ctClass.equals(superclass) && new Type(superclass).isAssignableTo(type)) {
                return true;
            }
            return Stream.of(this.ctClass.getInterfaces()).anyMatch(i -> new Type((CtClass)i).isAssignableTo(type));
        }
        catch (NotFoundException e) {
            LogProvider.error("Could not analyze superclass of: " + this.ctClass.getName() + ", reason: " + e.getMessage());
            LogProvider.debug(e);
            return false;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Type type = (Type)o;
        if (!this.ctClass.equals(type.ctClass)) {
            return false;
        }
        return this.typeParameters.equals(type.typeParameters);
    }

    public int hashCode() {
        int result = this.ctClass.hashCode();
        result = 31 * result + this.typeParameters.hashCode();
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.ctClass.getName());
        int lastIndexOf = builder.indexOf("[]");
        CharSequence suffix = null;
        if (lastIndexOf >= 0) {
            suffix = builder.subSequence(lastIndexOf, builder.length());
            builder.delete(lastIndexOf, builder.length());
        }
        if (!this.typeParameters.isEmpty()) {
            builder.append('<');
            builder.append(this.typeParameters.stream().map(Object::toString).collect(Collectors.joining(", ")));
            builder.append('>');
        }
        if (suffix != null) {
            builder.append(suffix);
        }
        return builder.toString();
    }
}

