/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.model.types;

import com.sebastian_daschner.jaxrs_analyzer.model.types.Type;
import com.sebastian_daschner.jaxrs_analyzer.model.types.Types;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;

abstract class TypeExtractor {
    TypeExtractor() {
    }

    static CtClass toErasuredClass(String type) throws BadBytecode, NotFoundException {
        int lastIndex;
        int index = type.indexOf(60);
        String className = index >= 0 ? ((lastIndex = type.lastIndexOf(62)) != type.length() - 1 ? type.substring(0, index) + type.substring(type.lastIndexOf(62) + 1, type.length()) : type.substring(0, index)) : type;
        return ClassPool.getDefault().get(className);
    }

    static List<Type> toTypeParameters(String descriptor) {
        int index = descriptor.indexOf(60);
        if (index < 0) {
            return Collections.emptyList();
        }
        String withoutPrefix = descriptor.substring(index + 1);
        int lastIndex = withoutPrefix.lastIndexOf(62);
        String nestedTypes = withoutPrefix.substring(0, lastIndex);
        return TypeExtractor.getTypesFirstLevel(nestedTypes).stream().map(Type::new).collect(Collectors.toList());
    }

    private static List<String> getTypesFirstLevel(String type) {
        LinkedList<String> types = new LinkedList<String>();
        int level = 0;
        int lastCut = 0;
        for (int i = 0; i < type.length(); ++i) {
            char character = type.charAt(i);
            if (character == '<') {
                ++level;
                continue;
            }
            if (character == '>') {
                --level;
                continue;
            }
            if (character != ',' || level != 0) continue;
            types.add(type.substring(lastCut, i).trim());
            lastCut = i + 1;
        }
        types.add(type.substring(lastCut).trim());
        return types;
    }

    private static CtClass convertPrimitive(String type) throws NotFoundException {
        switch (type) {
            case "boolean": {
                return Types.PRIMITIVE_BOOLEAN.getCtClass();
            }
            case "char": {
                return Types.PRIMITIVE_CHAR.getCtClass();
            }
            case "byte": {
                return Types.PRIMITIVE_BYTE.getCtClass();
            }
            case "short": {
                return Types.PRIMITIVE_SHORT.getCtClass();
            }
            case "int": {
                return Types.PRIMITIVE_INT.getCtClass();
            }
            case "long": {
                return Types.PRIMITIVE_LONG.getCtClass();
            }
            case "float": {
                return Types.PRIMITIVE_FLOAT.getCtClass();
            }
            case "double": {
                return Types.PRIMITIVE_DOUBLE.getCtClass();
            }
            case "void": {
                return Types.PRIMITIVE_VOID.getCtClass();
            }
        }
        throw new RuntimeException("Unknown primitive: " + type);
    }
}

