/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.maven;

import com.sebastian_daschner.jaxrs_analyzer.JAXRSAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerScheme;
import com.sebastian_daschner.jaxrs_analyzer.maven.BackendType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class JAXRSAnalyzerMojo
extends AbstractMojo {
    private String backend;
    private String deployedDomain;
    private String[] swaggerSchemes;
    private Boolean renderSwaggerTags;
    private Integer swaggerTagsPathOffset;
    private File outputDirectory;
    private File buildDirectory;
    private MavenProject project;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    private File resourcesDirectory;

    public void execute() throws MojoExecutionException {
        this.injectMavenLoggers();
        if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
            LogProvider.info((String)("skipping non existing directory " + this.outputDirectory));
            return;
        }
        BackendType backendType = this.getBackendType();
        Backend backend = this.configureBackend(backendType);
        LogProvider.info((String)("analyzing JAX-RS resources, using " + backend.getName() + " backend"));
        Set<Path> dependencyPaths = this.getDependencies();
        LogProvider.debug((String)("Dependency paths are: " + dependencyPaths));
        Set<Path> projectPaths = Collections.singleton(this.outputDirectory.toPath());
        LogProvider.debug((String)("Project paths are: " + projectPaths));
        this.resourcesDirectory = Paths.get(this.buildDirectory.getPath(), "jaxrs-analyzer").toFile();
        if (!this.resourcesDirectory.exists() && !this.resourcesDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + this.resourcesDirectory);
        }
        Path fileLocation = this.resourcesDirectory.toPath().resolve(backendType.getFileLocation());
        long start = System.currentTimeMillis();
        new JAXRSAnalyzer(projectPaths, dependencyPaths, this.project.getName(), this.project.getVersion(), backend, fileLocation).analyze();
        LogProvider.debug((String)("Analysis took " + (System.currentTimeMillis() - start) + " ms"));
    }

    private BackendType getBackendType() {
        switch (this.backend.toLowerCase()) {
            case "plaintext": {
                return BackendType.PLAINTEXT;
            }
            case "asciidoc": {
                return BackendType.ASCIIDOC;
            }
            case "swagger": {
                return BackendType.SWAGGER;
            }
        }
        throw new IllegalArgumentException("Backend " + this.backend + " not valid! Valid values are: " + Stream.of(BackendType.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")));
    }

    private Backend configureBackend(BackendType backendType) throws IllegalArgumentException {
        Set schemes = Stream.of(this.swaggerSchemes).map(this::getSwaggerScheme).collect(() -> EnumSet.noneOf(SwaggerScheme.class), Set::add, Set::addAll);
        switch (backendType) {
            case PLAINTEXT: {
                return Backend.plainText().build();
            }
            case ASCIIDOC: {
                return Backend.asciiDoc().build();
            }
            case SWAGGER: {
                return Backend.swagger().domain(this.deployedDomain).schemes(schemes).renderTags(this.renderSwaggerTags.booleanValue(), this.swaggerTagsPathOffset.intValue()).build();
            }
        }
        throw new IllegalArgumentException("Unknown backend type " + (Object)((Object)backendType));
    }

    private SwaggerScheme getSwaggerScheme(String scheme) {
        switch (scheme.toLowerCase()) {
            case "http": {
                return SwaggerScheme.HTTP;
            }
            case "https": {
                return SwaggerScheme.HTTPS;
            }
            case "ws": {
                return SwaggerScheme.WS;
            }
            case "wss": {
                return SwaggerScheme.WSS;
            }
        }
        throw new IllegalArgumentException("Swagger scheme " + scheme + " not valid! Valid values are: " + Stream.of(SwaggerScheme.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")));
    }

    private void injectMavenLoggers() {
        LogProvider.injectInfoLogger(arg_0 -> ((Log)this.getLog()).info(arg_0));
        LogProvider.injectDebugLogger(arg_0 -> ((Log)this.getLog()).debug(arg_0));
        LogProvider.injectErrorLogger(arg_0 -> ((Log)this.getLog()).error(arg_0));
    }

    private Set<Path> getDependencies() throws MojoExecutionException {
        this.project.setArtifactFilter(a -> true);
        Set artifacts = this.project.getArtifacts();
        if (artifacts.isEmpty()) {
            artifacts = this.project.getDependencyArtifacts();
        }
        Set<Path> dependencies = artifacts.stream().filter(a -> !a.getScope().equals("test")).map(org.apache.maven.artifact.Artifact::getFile).filter(Objects::nonNull).map(File::toPath).collect(Collectors.toSet());
        dependencies.add(this.fetchJavaEEAPI().toPath());
        return dependencies;
    }

    private File fetchJavaEEAPI() throws MojoExecutionException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact("javax:javaee-api:7.0");
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.remoteRepos);
        LogProvider.debug((String)("Resolving artifact " + artifact + " from " + this.remoteRepos));
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LogProvider.debug((String)("Resolved artifact " + artifact + " to " + result.getArtifact().getFile() + " from " + result.getRepository()));
        return result.getArtifact().getFile();
    }
}

