/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.maven;

import com.sebastian_daschner.jaxrs_analyzer.JAXRSAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.maven.BackendType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class JAXRSAnalyzerMojo
extends AbstractMojo {
    private String backend;
    private String deployedDomain;
    private String[] swaggerSchemes;
    private Boolean renderSwaggerTags;
    private Integer swaggerTagsPathOffset;
    private File outputDirectory;
    private File sourceDirectory;
    private File buildDirectory;
    private MavenProject project;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;

    public void execute() throws MojoExecutionException {
        this.injectMavenLoggers();
        if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
            LogProvider.info((String)("skipping non existing directory " + this.outputDirectory));
            return;
        }
        BackendType backendType = this.getBackendType();
        Backend backend = this.configureBackend(backendType);
        LogProvider.info((String)("analyzing JAX-RS resources, using " + backend.getName() + " backend"));
        Set<Path> classPaths = this.getDependencies();
        LogProvider.debug((String)("Dependency class paths are: " + classPaths));
        Set<Path> projectPaths = Collections.singleton(this.outputDirectory.toPath());
        LogProvider.debug((String)("Project paths are: " + projectPaths));
        Set<Path> sourcePaths = Collections.singleton(this.sourceDirectory.toPath());
        LogProvider.debug((String)("Source paths are: " + sourcePaths));
        File resourcesDirectory = Paths.get(this.buildDirectory.getPath(), "jaxrs-analyzer").toFile();
        if (!resourcesDirectory.exists() && !resourcesDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + resourcesDirectory);
        }
        Path fileLocation = resourcesDirectory.toPath().resolve(backendType.getFileLocation());
        long start = System.currentTimeMillis();
        new JAXRSAnalyzer(projectPaths, sourcePaths, classPaths, this.project.getName(), this.project.getVersion(), backend, fileLocation).analyze();
        LogProvider.debug((String)("Analysis took " + (System.currentTimeMillis() - start) + " ms"));
    }

    private BackendType getBackendType() {
        switch (this.backend.toLowerCase()) {
            case "plaintext": {
                return BackendType.PLAINTEXT;
            }
            case "asciidoc": {
                return BackendType.ASCIIDOC;
            }
            case "swagger": {
                return BackendType.SWAGGER;
            }
        }
        throw new IllegalArgumentException("Backend " + this.backend + " not valid! Valid values are: " + Stream.of(BackendType.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")));
    }

    private Backend configureBackend(BackendType backendType) throws IllegalArgumentException {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("swaggerSchemes", Stream.of(this.swaggerSchemes).collect(Collectors.joining(",")));
        config.put("domain", this.deployedDomain);
        config.put("renderSwaggerTags", this.renderSwaggerTags.toString());
        config.put("swaggerTagsPathOffset", this.swaggerTagsPathOffset.toString());
        Backend backend = JAXRSAnalyzer.constructBackend((String)backendType.name());
        backend.configure(config);
        return backend;
    }

    private void injectMavenLoggers() {
        LogProvider.injectInfoLogger(arg_0 -> ((Log)this.getLog()).info(arg_0));
        LogProvider.injectDebugLogger(arg_0 -> ((Log)this.getLog()).debug(arg_0));
        LogProvider.injectErrorLogger(arg_0 -> ((Log)this.getLog()).error(arg_0));
    }

    private Set<Path> getDependencies() throws MojoExecutionException {
        this.project.setArtifactFilter(a -> true);
        Set artifacts = this.project.getArtifacts();
        if (artifacts.isEmpty()) {
            artifacts = this.project.getDependencyArtifacts();
        }
        Set<Path> dependencies = artifacts.stream().filter(a -> !a.getScope().equals("test")).map(org.apache.maven.artifact.Artifact::getFile).filter(Objects::nonNull).map(File::toPath).collect(Collectors.toSet());
        String analyzerVersion = ((org.apache.maven.artifact.Artifact)this.project.getPluginArtifactMap().get("com.sebastian-daschner:jaxrs-analyzer-maven-plugin")).getVersion();
        dependencies.add(this.fetchDependency("javax:javaee-api:7.0"));
        dependencies.add(this.fetchDependency("com.sebastian-daschner:jaxrs-analyzer:" + analyzerVersion));
        return dependencies;
    }

    private Path fetchDependency(String artifactIdentifier) throws MojoExecutionException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact(artifactIdentifier);
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.remoteRepos);
        LogProvider.debug((String)("Resolving artifact " + artifact + " from " + this.remoteRepos));
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LogProvider.debug((String)("Resolved artifact " + artifact + " to " + result.getArtifact().getFile() + " from " + result.getRepository()));
        return result.getArtifact().getFile().toPath();
    }
}

