/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.maven;

import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.analysis.ProjectAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.maven.MavenBackend;
import com.sebastian_daschner.jaxrs_analyzer.model.rest.Resources;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class JAXRSAnalyzerMojo
extends AbstractMojo {
    private String backend;
    private File outputDirectory;
    private File buildDirectory;
    private MavenProject project;
    private File resourcesDirectory;
    private Consumer<String> logger;

    public void execute() throws MojoExecutionException {
        this.injectLoggers();
        if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
            this.logger.accept("skipping non existing directory " + this.outputDirectory);
            return;
        }
        MavenBackend mavenBackend = MavenBackend.forName(this.backend);
        if (mavenBackend == null) {
            throw new MojoExecutionException("Backend " + this.backend + " not valid! Valid values are: " + Stream.of(MavenBackend.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")));
        }
        this.logger.accept("analyzing JAX-RS resources, using " + mavenBackend.getName());
        List<Path> dependencyPaths = this.project.getDependencyArtifacts().stream().map(Artifact::getFile).map(File::toPath).collect(Collectors.toList());
        ProjectAnalyzer projectAnalyzer = new ProjectAnalyzer(dependencyPaths.toArray(new Path[dependencyPaths.size()]));
        Resources resources = projectAnalyzer.analyze(this.outputDirectory.toPath());
        if (!this.isEmpty(resources)) {
            this.resourcesDirectory = Paths.get(this.buildDirectory.getPath(), "jaxrs-analyzer").toFile();
            if (!this.resourcesDirectory.exists() && !this.resourcesDirectory.mkdirs()) {
                throw new MojoExecutionException("Could not create directory " + this.resourcesDirectory);
            }
            this.writeOutput(mavenBackend, resources);
        }
    }

    private void injectLoggers() {
        LogProvider.injectLogger(arg_0 -> ((Log)this.getLog()).info(arg_0));
        this.logger = LogProvider.getLogger();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isEmpty(Resources resources) {
        if (resources.getResources().isEmpty()) return true;
        if (!resources.getResources().stream().map(arg_0 -> ((Resources)resources).getMethods(arg_0)).noneMatch(s -> !s.isEmpty())) return false;
        return true;
    }

    private void writeOutput(MavenBackend mavenBackend, Resources resources) throws MojoExecutionException {
        File touch = new File(this.resourcesDirectory, mavenBackend.getFileName());
        try (FileWriter writer = new FileWriter(touch);){
            Backend backend = mavenBackend.instantiateBackend();
            writer.write(backend.render(resources));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not create file " + touch, (Exception)e);
        }
    }
}

