/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.maven;

import com.sebastian_daschner.jaxrs_analyzer.backend.Backend;
import com.sebastian_daschner.jaxrs_analyzer.backend.plaintext.PlainTextBackend;
import com.sebastian_daschner.jaxrs_analyzer.backend.swagger.SwaggerBackend;
import java.util.function.Supplier;
import java.util.stream.Stream;

public enum MavenBackend {
    PLAINTEXT("Plain text backend", "rest-resources.txt"),
    SWAGGER("Swagger backend", "swagger.json");

    private String name;
    private String fileName;
    private Supplier<Backend> backendSupplier;

    private MavenBackend(String name, String fileName) {
        this.name = name;
        this.fileName = fileName;
    }

    public String getFileName() {
        return this.fileName;
    }

    public Backend instantiateBackend() {
        return this == PLAINTEXT ? new PlainTextBackend() : new SwaggerBackend();
    }

    public String getName() {
        return this.name;
    }

    public static MavenBackend forName(String backendName) {
        return Stream.of(MavenBackend.values()).filter(e -> e.name().toLowerCase().equals(backendName)).findAny().orElse(null);
    }
}

