/*
 * Decompiled with CFR 0.152.
 */
package com.sebastian_daschner.jaxrs_analyzer.maven;

import com.sebastian_daschner.jaxrs_analyzer.JAXRSAnalyzer;
import com.sebastian_daschner.jaxrs_analyzer.LogProvider;
import com.sebastian_daschner.jaxrs_analyzer.backend.BackendType;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

public class JAXRSAnalyzerMojo
extends AbstractMojo {
    private String backend;
    private String deployedDomain;
    private File outputDirectory;
    private File buildDirectory;
    private MavenProject project;
    private RepositorySystem repoSystem;
    private RepositorySystemSession repoSession;
    private List<RemoteRepository> remoteRepos;
    private File resourcesDirectory;

    public void execute() throws MojoExecutionException {
        this.injectMavenLoggers();
        if (!this.outputDirectory.exists() || !this.outputDirectory.isDirectory()) {
            LogProvider.info((String)("skipping non existing directory " + this.outputDirectory));
            return;
        }
        BackendType backendType = BackendType.getByNameIgnoreCase((String)this.backend);
        if (backendType == null) {
            throw new MojoExecutionException("Backend " + this.backend + " not valid! Valid values are: " + Stream.of(BackendType.values()).map(Enum::name).map(String::toLowerCase).collect(Collectors.joining(", ")));
        }
        LogProvider.info((String)("analyzing JAX-RS resources, using " + backendType.getName() + " backend"));
        Set<Path> dependencyPaths = this.getDependencies();
        LogProvider.debug((String)("Dependency paths are: " + dependencyPaths));
        Set<Path> projectPaths = Collections.singleton(this.outputDirectory.toPath());
        LogProvider.debug((String)("Project paths are: " + projectPaths));
        this.resourcesDirectory = Paths.get(this.buildDirectory.getPath(), "jaxrs-analyzer").toFile();
        if (!this.resourcesDirectory.exists() && !this.resourcesDirectory.mkdirs()) {
            throw new MojoExecutionException("Could not create directory " + this.resourcesDirectory);
        }
        Path fileLocation = this.determineFileLocation(backendType);
        long start = System.currentTimeMillis();
        new JAXRSAnalyzer(projectPaths, dependencyPaths, backendType, this.project.getName(), this.project.getVersion(), this.deployedDomain, fileLocation).analyze();
        LogProvider.debug((String)("Analysis took " + (System.currentTimeMillis() - start) + " ms"));
    }

    private void injectMavenLoggers() {
        LogProvider.injectInfoLogger(arg_0 -> ((Log)this.getLog()).info(arg_0));
        LogProvider.injectDebugLogger(arg_0 -> ((Log)this.getLog()).debug(arg_0));
        LogProvider.injectErrorLogger(arg_0 -> ((Log)this.getLog()).error(arg_0));
    }

    private Set<Path> getDependencies() throws MojoExecutionException {
        this.project.setArtifactFilter(a -> true);
        Set artifacts = this.project.getArtifacts();
        if (artifacts.isEmpty()) {
            artifacts = this.project.getDependencyArtifacts();
        }
        Set<Path> dependencies = artifacts.stream().map(org.apache.maven.artifact.Artifact::getFile).filter(Objects::nonNull).map(File::toPath).collect(Collectors.toSet());
        dependencies.add(this.fetchJavaEEAPI().toPath());
        return dependencies;
    }

    private File fetchJavaEEAPI() throws MojoExecutionException {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        DefaultArtifact artifact = new DefaultArtifact("javax:javaee-api:7.0");
        request.setArtifact((Artifact)artifact);
        request.setRepositories(this.remoteRepos);
        LogProvider.debug((String)("Resolving artifact " + artifact + " from " + this.remoteRepos));
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
        LogProvider.debug((String)("Resolved artifact " + artifact + " to " + result.getArtifact().getFile() + " from " + result.getRepository()));
        return result.getArtifact().getFile();
    }

    private Path determineFileLocation(BackendType backendType) {
        switch (backendType) {
            case PLAINTEXT: {
                return this.resourcesDirectory.toPath().resolve("rest-resources.txt");
            }
            case ASCIIDOC: {
                return this.resourcesDirectory.toPath().resolve("rest-resources.adoc");
            }
            case SWAGGER: {
                return this.resourcesDirectory.toPath().resolve("swagger.json");
            }
        }
        throw new IllegalArgumentException("Unknown backend type " + backendType);
    }
}

