/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import com.segment.analytics.messages.AliasMessage;
import com.segment.analytics.messages.GroupMessage;
import com.segment.analytics.messages.IdentifyMessage;
import com.segment.analytics.messages.Message;
import com.segment.analytics.messages.MessageBuilder;
import com.segment.analytics.messages.PageMessage;
import com.segment.analytics.messages.ScreenMessage;
import com.segment.analytics.messages.TrackMessage;

public interface MessageTransformer {
    public boolean transform(MessageBuilder var1);

    public static abstract class Typed
    implements MessageTransformer {
        @Override
        public final boolean transform(MessageBuilder builder) {
            Message.Type type = builder.type();
            switch (type) {
                case alias: {
                    return this.alias((AliasMessage.Builder)builder);
                }
                case group: {
                    return this.group((GroupMessage.Builder)builder);
                }
                case identify: {
                    return this.identify((IdentifyMessage.Builder)builder);
                }
                case screen: {
                    return this.screen((ScreenMessage.Builder)builder);
                }
                case page: {
                    return this.page((PageMessage.Builder)builder);
                }
                case track: {
                    return this.track((TrackMessage.Builder)builder);
                }
            }
            throw new IllegalArgumentException("Unknown payload type: " + type);
        }

        abstract boolean alias(AliasMessage.Builder var1);

        abstract boolean group(GroupMessage.Builder var1);

        abstract boolean identify(IdentifyMessage.Builder var1);

        abstract boolean screen(ScreenMessage.Builder var1);

        abstract boolean page(PageMessage.Builder var1);

        abstract boolean track(TrackMessage.Builder var1);
    }
}

