/*
 * Decompiled with CFR 0.152.
 */
package com.segment.analytics;

import com.squareup.okhttp.OkHttpClient;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import retrofit.client.Client;
import retrofit.client.OkClient;

class Platform {
    static final String THREAD_NAME = "Analytics";
    private static final Platform PLATFORM = Platform.findPlatform();

    Platform() {
    }

    static Platform get() {
        return PLATFORM;
    }

    private static Platform findPlatform() {
        return new Platform();
    }

    Client defaultClient() {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(15L, TimeUnit.SECONDS);
        client.setReadTimeout(15L, TimeUnit.SECONDS);
        client.setWriteTimeout(15L, TimeUnit.SECONDS);
        return new OkClient(client);
    }

    ExecutorService defaultNetworkExecutor() {
        return Executors.newSingleThreadExecutor(this.defaultThreadFactory());
    }

    ThreadFactory defaultThreadFactory() {
        return new ThreadFactory(){

            @Override
            public Thread newThread(final Runnable r) {
                return new Thread(new Runnable(){

                    @Override
                    public void run() {
                        Thread.currentThread().setPriority(1);
                        r.run();
                    }
                }, Platform.THREAD_NAME);
            }
        };
    }

    public long defaultFlushIntervalInMillis() {
        return 10000L;
    }

    public int defaultFlushQueueSize() {
        return 250;
    }
}

